% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-announcements.R
\name{fetch_fishing_announcements}
\alias{fetch_fishing_announcements}
\title{Fetch fishing announcements from external sources}
\usage{
fetch_fishing_announcements(
  start_date,
  end_date,
  download = FALSE,
  download_dir = "downloads",
  batch_size = 10,
  verbose = TRUE,
  source_url = NULL,
  max_records = 5000
)
}
\arguments{
\item{start_date}{Start date in "dd/mm/yyyy" format.}

\item{end_date}{End date in "dd/mm/yyyy" format.}

\item{download}{Logical. Download PDF files.}

\item{download_dir}{Directory for downloaded files.}

\item{batch_size}{Records per request.}

\item{verbose}{Print detailed information.}

\item{source_url}{Base URL for the announcement source. Defaults to the PRODUCE page:
\url{https://consultasenlinea.produce.gob.pe/ConsultasEnLinea/consultas.web/comunicados/suspensionPreventiva}}

\item{max_records}{Maximum records to retrieve.}
}
\value{
Data frame with announcement information and download links.
}
\description{
Retrieves fishing announcements from official websites within a specified date range.
This function is specifically designed for PRODUCE (Peru) but can be adapted for other sources.
}
\examples{
\dontrun{
announcements <- fetch_fishing_announcements(
  start_date = "01/01/2023",
  end_date = "31/12/2023"
)

announcements <- fetch_fishing_announcements(
  start_date = "01/01/2023",
  end_date = "31/01/2023",
  download = TRUE,
  download_dir = "announcements"
)
}

}
