% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-announcements.R
\name{extract_pdf_data}
\alias{extract_pdf_data}
\title{Extract data from PDF announcements}
\usage{
extract_pdf_data(
  pdf_sources = NULL,
  temp_dir = NULL,
  verbose = TRUE,
  max_retries = 3
)
}
\arguments{
\item{pdf_sources}{Character vector of PDF file paths or URLs.}

\item{temp_dir}{Temporary directory for downloaded files. If NULL, uses tempdir().}

\item{verbose}{Show processing messages.}

\item{max_retries}{Maximum download retries for URLs.}
}
\value{
Data frame with extracted announcement information including coordinates,
dates, and nautical mile distances.
}
\description{
Processes PDF files containing official fishing announcements and extracts relevant information
such as dates, coordinates, and nautical miles. Handles both local files and URLs.
}
\examples{
\dontrun{
pdf_files <- c("announcement1.pdf", "announcement2.pdf")
results <- extract_pdf_data(pdf_sources = pdf_files)

pdf_urls <- c(
  "https://example.com/announcement1.pdf",
  "https://example.com/announcement2.pdf"
)
results <- extract_pdf_data(pdf_sources = pdf_urls)
}

}
