% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempCompCurve.R
\name{tempCompCurve}
\alias{tempCompCurve}
\title{Calculate V-DeltaT Curve}
\usage{
tempCompCurve(x, Tdata)
}
\arguments{
\item{x}{a vector containing the values of R1 R2 R3 R4 Rb1 Beta1 Rb2 Beta2}

\item{Tdata}{a vector of temperature-change values}
}
\value{
the voltage values at Point B
}
\description{
Calculating the temperature-change-voltage curve for a
    particular set of Resistor and Thermistor Values.
}
\examples{
Tdata <- seq(-40, 85, by=5)
R_values <- c(1100, 4300, 560, 1100, 220, 3680, 1000, 3560)
tempCompCurve(x = R_values, Tdata = Tdata)
}
