#
#   TTR: Technical Trading Rules
#
#   Copyright (C) 2007-2011  Joshua M. Ulrich
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"CLV" <-
function(HLC) {

  # Close Location Value

  # http://stockcharts.com/education/IndicatorAnalysis/indic_AccumDistLine.html

  HLC <- try.xts(HLC, error=as.matrix)
  clv <- ((HLC[,3]-HLC[,2]) - (HLC[,1]-HLC[,3])) / (HLC[,1]-HLC[,2])

  # Account for H=L=C
  clv[is.nan(clv)] <- 0

  if(is.xts(clv)) colnames(clv) <- 'clv'
  reclass( clv, HLC )
}
