% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TopDown_localTest.R
\name{TopDown_localTest}
\alias{TopDown_localTest}
\title{TopDown localTest algorithm for estimating a 1-alpha confidence set for the number
of false hypotheses among a set.}
\usage{
TopDown_localTest(
  localTest,
  pvals,
  subset = NULL,
  alpha = 0.05,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{localTest}{A function specifying a local test.}

\item{pvals}{A vector of p-values}

\item{subset}{Numeric vector specifying a subset a p-values to estimate a
confidence set for the number of false hypotheses for. Defaults to NULL
corresponding to estimating a confidence set for the number of false
hypotheses in the entire set.}

\item{alpha}{Level in [0,1] at which to generate confidence set. Defaults
to 0.05}

\item{verbose}{Logical, indicating whether or not to write out the progress.
Defaults to TRUE}

\item{...}{Additional parameters}
}
\value{
A lower 1-alpha bound for the number of false hypotheses among the
set of supplied p-values
}
\description{
TopDown localTest algorithm for estimating a 1-alpha confidence set for the number
of false hypotheses among a set.
}
\examples{
## Simulate some p-values
## The first 10 are from false hypotheses, the next 10 are from true
pvals <- c (
  rbeta(10, 1, 20),  ## Mean value of .05
  runif(10)
)
## Estimate the confidence set using a local Bonferroni test
TopDown_localTest(function(x) {min(c(1, length(x) * min(x)))}, pvals)
}
