% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matern-acf.R
\name{matern.acf}
\alias{matern.acf}
\title{Matern autocorrelation function.}
\usage{
matern.acf(tseq, lambda, nu)
}
\arguments{
\item{tseq}{Vector of time points at which the autocorrelation is to be calculated.}

\item{lambda}{Timescale parameter.}

\item{nu}{Smoothness parameter.}
}
\value{
An autocorrelation vector of length \code{N}.
}
\description{
Matern autocorrelation function.
}
\details{
The Matern autocorrelation is given by
\deqn{
\mathrm{\scriptsize ACF}(t) = \frac{2^{1-\nu}}{\Gamma(\nu)} \left(\sqrt{2\nu}\frac{t}{\lambda}\right)^\nu K_\nu\left(\sqrt{2\nu} \frac{t}{\lambda}\right),
}{
acf(t) = 2^(1-\nu)/\Gamma(\nu) * (\sqrt{2\nu} * t/\lambda)^\nu * K_\nu(\sqrt{2\nu} * t/\lambda),
}
where \eqn{K_\nu(x)} is the modified Bessel function of second kind.
}
\examples{
matern.acf(tseq = 1:10, lambda = 1, nu = 3/2)
}
