% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/every_nth.R
\name{every_nth}
\alias{every_nth}
\title{Suppresses every n th element of a vector}
\usage{
every_nth(x, nth, empty = TRUE, inverse = FALSE)
}
\arguments{
\item{x}{a vector (numbers, integers, characters, you name it)}

\item{nth}{the multiple of position where the elements will be
suppressed (nth + 1 actually) or kept (if inverse = T)}

\item{empty}{whether the suppressed element should be replaced by ""}

\item{inverse}{opposite reaction: n th elements only will be kept}
}
\value{
a vector with the remaining values
}
\description{
Suppresses every n th element of a vector
}
\examples{
numvec <- 0:20

every_nth(numvec, 3)

every_nth(numvec, 3, empty = FALSE)

every_nth(numvec, 3, inverse = TRUE)

every_nth(numvec, 3, empty = FALSE, inverse = TRUE)

}
\seealso{
practical usage of this function for axes: \code{\link{minorAxis}}
}
\author{
Adam D. Smith
}
