% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_to_paleoTS.R
\name{reduce_to_paleoTS}
\alias{reduce_to_paleoTS}
\title{reduce pre-paleoTS format to paleoTS}
\usage{
reduce_to_paleoTS(x, min_n = 1, na.rm = TRUE, ...)
}
\arguments{
\item{x}{a \code{pre_paleoTS} object}

\item{min_n}{minimum number of specimens. If the number of specimens at a sampling location falls below this number, the sampling location will be removed}

\item{na.rm}{Logical. If sampling locations are NA (e.g., because of erosion), should the sample be removed?}

\item{...}{other options. currently unused}
}
\value{
a \code{paleoTS} object
}
\description{
paleoTS is a format for paleontological time series. It is a summary format where interpopulation variance is provided as a parameter. As a result, taphonomic and ecological effects that act on individual specimens can not be modeled for paleoTS objects. To resolve this, the pre_paleoTS format tracks each specimen individually. This function reduces the pre-paleoTS format into standard paleoTS object, which can be used by the paleoTS package.
}
\examples{
x = stasis_sl(t = 0:5)     # create pre_paleoTS object representing stasis on specimen level
y = reduce_to_paleoTS(x)   # reduce to standard paleoTS format
plot(y)
# now analyses using the paleoTS package can be applied to y

}
\seealso{
\itemize{
\item \code{\link[=stasis_sl]{stasis_sl()}}, \link{strict_stasis_sl}, \link{random_walk_sl}, and \code{\link[=ornstein_uhlenbeck_sl]{ornstein_uhlenbeck_sl()}} to simulate trait evolution on specimen level (sl), returning an object of type \code{pre_paleoTS}
}
}
