% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/youth_apply_sojourn.R
\name{apply_youth_sojourn}
\alias{apply_youth_sojourn}
\title{Apply the youth Sojourn method}
\usage{
apply_youth_sojourn(
  AG,
  vm = c("Vector.Magnitude", "ENMO"),
  Site = c("Hip", "Wrist"),
  demo_interactive = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{AG}{a data frame of monitor and demographic data}

\item{vm}{the variable to use for processing, either
\code{"Vector.Magnitude"} (for activity counts) or \code{"ENMO"} (for raw
acceleration)}

\item{Site}{the wear location of the monitor, either \code{"Hip"} or
\code{"Wrist"}}

\item{demo_interactive}{logical. Input demographics interactively if missing
variables are identified during format checking?}

\item{verbose}{logical. Print processing updates to the console?}

\item{...}{Further arguments passed to \code{\link{youth_name_test}}}
}
\value{
The original data frame, plus additional predictions made by the
  Sojourn method
}
\description{
Function for using the youth Sojourn method developed by
\href{https://pubmed.ncbi.nlm.nih.gov/29135657/}{Hibbing et al. (2018)}
}
\note{
The functions \code{AGread::read_AG_counts} and
  \code{AGread::read_AG_raw} are recommended for assembling the
  monitor-specific portion of the \code{AG} data frame.
}
\examples{
data(example_data, package = "Sojourn")
\donttest{
  results_youth_soj <- apply_youth_sojourn(
    AG = example_data,
    vm = "Vector.Magnitude",
    Site = "Hip"
  )
  utils::head(results_youth_soj)
}
}
