% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_method.R
\name{add_method}
\alias{add_method}
\title{Add a "method" function}
\usage{
add_method(sim, name, fn)
}
\arguments{
\item{sim}{A simulation object of class \code{sim_obj}, usually created by
\code{\link{new_sim}}}

\item{name}{A name for the method function}

\item{fn}{A method function}
}
\value{
The original simulation object with the new method function added
}
\description{
Add a "method" function to your simulation object. A method
    function is just a function, and can be used anywhere that you would
    normally write and use a regular global function. The advantages of
    explicitly adding a method function to your simulation (rather than
    declaring and using a function within your simulation script) are that
    (1) you can use the method function as a simulation level, and (2)
    parallelization is automated. Often, the method function will be a
    statistical method that you want to test (e.g. an estimator), and will
    take in a dataset returned by a creator function as its first argument;
    however, this is not always the case.
}
\details{
\itemize{
  \item{As with \code{\link{add_creator}}, there are two ways to use
    \code{add_method}. If two arguments are supplied (\code{sim} and
    \code{fn}), you can create a function separately and add it to your
    simulation object later. If three arguments are supplied, you can do both
    at the same time, using an anonymous function for the \code{fn} argument.
    See examples.}
  \item{Your method will be stored in \code{sim$methods}. If you added a
    method called \code{estimator_1}, you can test it out by running
    \code{sim$creators$estimator_1()}. See examples.}
}
}
\examples{
sim <- new_sim()
sim \%<>\% add_creator("create_data", function(n) { rpois(n, lambda=5) })

# The first way to use add_method is to declare a function and add it to
# your simulation object later:

estimator_1 <- function (dat) { mean(dat) }
sim \%<>\% add_method(estimator_1)

# The second way is to do both at the same time:

sim \%<>\% add_method("estimator_2", function(dat) {
  var(dat)
})

# With either option, you can test your function as follows:

dat <- sim$creators$create_data(10)
sim$methods$estimator_1(dat)
sim$methods$estimator_2(dat)
}
