% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_simulations.R
\name{aggregate_simulations}
\alias{aggregate_simulations}
\title{Collapse separate simulation files into a single result}
\usage{
aggregate_simulations(files = NULL)
}
\arguments{
\item{files}{a \code{character} vector containing the names of the simulation files. If \code{NULL},
all files in the working directory ending in \code{.rds} will be used}
}
\value{
a \code{data.frame} with the (weighted) average of the simulation results
}
\description{
This function grabs all \code{.rds} files in the working directory and aggregates them into a single
\code{data.frame} object.
}
\examples{
\dontrun{

setwd('my_working_directory')

final <- aggregate_simulations()
head(final)

saveRDS(final, 'my_final_simulation.rds')

}
}
\seealso{
\code{\link{runSimulation}}
}

