% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{GroupCorrelation}
\alias{GroupCorrelation}
\title{Compute the correlation of features broken down by groups with another
covariate}
\usage{
GroupCorrelation(
  object,
  assay = NULL,
  slot = "scale.data",
  var = NULL,
  group.assay = NULL,
  min.cells = 5,
  ngroups = 6,
  do.plot = TRUE
)
}
\arguments{
\item{object}{Seurat object}

\item{assay}{Assay to pull the data from}

\item{slot}{Slot in the assay to pull feature expression data from (counts,
data, or scale.data)}

\item{var}{Variable with which to correlate the features}

\item{group.assay}{Compute the gene groups based off the data in this assay.}

\item{min.cells}{Only compute for genes in at least this many cells}

\item{ngroups}{Number of groups to split into}

\item{do.plot}{Display the group correlation boxplot (via
\code{GroupCorrelationPlot})}
}
\value{
A Seurat object with the correlation stored in metafeatures
}
\description{
Compute the correlation of features broken down by groups with another
covariate
}
\concept{utilities}
