% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Outlier.R
\encoding{UTF-8}
\name{Outlier}
\alias{Outlier}
\alias{Outlier.default}
\title{Detect Outliers}
\usage{
Outlier(x, index = NULL, ...)

\method{Outlier}{default}(x, index = NULL, ...)
}
\arguments{
\item{x}{A numeric object, a vector.}

\item{index}{A numeric value to be considered in the computations.}

\item{\dots}{Parameters which are typically ignored.}
}
\value{
Returns the minimum and maximum values, respectively preceded by their positions in the \code{vector}, \code{matrix} or \code{data.frame}.
}
\description{
Perform exploratory test to detect \emph{outliers}.
}
\details{
The quantity in \emph{min} reveals the minimum deviation from the mean, the integer value in the \emph{closest} indicates the position of that element. The quantity in \emph{max} is the maximum deviation from the mean, and the \code{farthest} integer value indicates the position of that value.
}
\examples{
Outlier(x <- rnorm(20))

#data frame:
age <- sample(1:100, 1000, rep=TRUE);
Outlier(age)

}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\references{
Dixon, W.J. (1950) Analysis of extreme values. \emph{Ann. Math. Stat.} \bold{21(4),} 488--506.
}
\seealso{
\link{Winsorize} for reduce the impact of outliers.
}
\keyword{Exploratory}

