% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Palettes.R
\name{pub_pal}
\alias{pub_pal}
\title{Color Palettes for Publication (discrete)}
\usage{
pub_pal(palette = "pub12")
}
\arguments{
\item{palette}{the palette name, a character string.}
}
\description{
Color palettes for publication-quality graphs. See details.
}
\details{
The following palettes are available:
\itemize{
\item {"scipo"}{A 12-color colorblind discrete palette.}
\item{"gray9"}{5-tons of gray.}
\item {"carnival"}{A 5-color palette inspired in the Brazilian samba schools.}
\item {"tableau20"}{Based on software \href{http://www.tableausoftware.com/}{Tableau}}
\item {"tableau10"}{Based on software \href{http://www.tableausoftware.com/}{Tableau}}
 \item {"tableau10light"}{Based on software \href{http://www.tableausoftware.com/}{Tableau}}
\item {"tableau10medium"}{Based on software \href{http://www.tableausoftware.com/}{Tableau}}
 \item {"fte"}{fivethirtyeight.com color scales}
}
}
\examples{
library(scales)
library(ggplot2)

show_col(pub_pal("scipo")(12))
show_col(pub_pal("gray9")(9), labels = FALSE)
show_col(pub_pal("carnival")(4))
show_col(pub_pal("gdocs")(18))
show_col(pub_pal("manyeyes")(20))
show_col(pub_pal("tableau10")(10))
show_col(pub_pal("tableau10medium")(10))
show_col(pub_pal("tableau10light")(10))
show_col(pub_pal("cyclic")(20))
show_col(pub_pal("bivariate1")(9))

}
\keyword{ggplot2}

