% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LargestRemainders.R
\encoding{latin1}
\name{LargestRemainders}
\alias{LargestRemainders}
\alias{LargestRemainders.default}
\title{Largest Remainders Methods of Allocating Seats Proportionally}
\usage{
LargestRemainders(parties = NULL, votes = NULL, seats = NULL,
  method = c("hare", "droop", "hagb", "imperiali", "imperiali.adj"),
  threshold = 0, ...)

\method{LargestRemainders}{default}(parties = NULL, votes = NULL,
  seats = NULL, method = c("hare", "droop", "hagb", "imperiali",
  "imperiali.adj"), threshold = 0, ...)
}
\arguments{
\item{parties}{A character vector for parties labels or candidates in the order as \code{votes}. If \code{NULL}, a random combination of letters will be assigned.}

\item{votes}{A numeric vector for the number of formal votes received by each party or candidate.}

\item{seats}{The number of seats to be filled (scalar or vector).}

\item{method}{A character name for the method to be used. See details.}

\item{threshold}{A numeric value between (0~1). Default is set to 0.}

\item{\dots}{Additional arguements (currently ignored)}
}
\value{
A \code{data.frame} of length \code{parties} containing apportioned integers (seats) summing to \code{seats}.
}
\description{
Computes the largest remainders method for a variety of formulas of allocating seats proportionally.
}
\details{
The following methods are available:
\itemize{
\item {"droop"}{Droop quota method}
\item {"hare"}{Hare method}
\item {"hagb"}{Hagenbach-Bischoff}
\item {"imperiali"}{Imperiali quota (do not confuse with the Italian Imperiali, which is a highest averages method)}
\item {"imperiali.adj"}{Reinforced or adjusted Imperiali quota}
}
}
\examples{
# Let's create a data.frame with typical election results
# with the following parties and votes to return 10 seats:

my_election_data <- data.frame(
party=c("Yellow", "White", "Red", "Green", "Blue", "Pink"),
votes=c(47000, 16000,	15900,	12000,	6000,	3100))

LargestRemainders(my_election_data$party,
my_election_data$votes, seats = 10,  method="droop")

with(my_election_data, LargestRemainders(party,
votes, seats = 10,  method="hare"))

}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}.
}
\references{
Gallagher, Michael (1992). "Comparing Proportional Representation
Electoral Systems: Quotas, Thresholds, Paradoxes and Majorities".
\emph{British Journal of Political Science}, 22, 4, 469-496.

 Lijphart, Arend (1994). \emph{Electoral Systems and Party Systems: A Study of Twenty-Seven Democracies, 1945-1990}. Oxford University Press.
}
\seealso{
\code{\link{HighestAverages}}, \code{\link{Proportionality}}, \code{\link{PoliticalDiversity}}. For more details see the \emph{Indices} vignette: \code{vignette('Indices', package = 'SciencesPo')}.
}
\keyword{Electoral}

