% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projINLA.R
\name{getSmoothed}
\alias{getSmoothed}
\title{Function to obtain projected estimates from INLA for each time and region.}
\usage{
getSmoothed(inla_mod, year_range = c(1985, 2019),
  year_label = c("85-89", "90-94", "95-99", "00-04", "05-09", "10-14",
  "15-19"), Amat = NULL, nsim = 1000, weight.strata = NULL,
  verbose = FALSE, mc = 0, include_time_unstruct = FALSE, ...)
}
\arguments{
\item{inla_mod}{output from \code{\link{fitINLA}}}

\item{year_range}{range corresponding to year label}

\item{year_label}{vector of year string vector}

\item{Amat}{adjacency matrix}

\item{nsim}{number of simulations}

\item{weight.strata}{a data frame with three columns, years, region, and proportion of each strata for the corresponding time period and region.}

\item{verbose}{logical indicator whether to print progress messages from inla.posterior.sample.}

\item{mc}{number of monte carlo draws to approximate the marginal prevalence/hazards for binomial model. If mc = 0, analytical approximation is used. The analytical approximation is invalid for hazard modeling with more than one age groups.}

\item{include_time_unstruct}{logical indicator whether to include the temporal unstructured effects (i.e., shocks) in the smoothed estimates.}

\item{...}{additional configurations passed to inla.posterior.sample.}
}
\value{
Results from RW2 model fit, including projection.
}
\description{
Function to obtain projected estimates from INLA for each time and region.
}
\examples{
\dontrun{
years <- levels(DemoData[[1]]$time)

# obtain direct estimates
data <- getDirectList(births = DemoData, 
years = years,  
regionVar = "region", timeVar = "time", 
clusterVar = "~clustid+id", 
ageVar = "age", weightsVar = "weights", 
geo.recode = NULL)
# obtain direct estimates
data_multi <- getDirectList(births = DemoData, years = years,
  regionVar = "region",  timeVar = "time", clusterVar = "~clustid+id",
  ageVar = "age", weightsVar = "weights", geo.recode = NULL)
data <- aggregateSurvey(data_multi)

#  national model
years.all <- c(years, "15-19")
fit1 <- fitINLA(data = data, geo = NULL, Amat = NULL, 
  year_label = years.all, year_range = c(1985, 2019), 
  rw = 2, is.yearly=FALSE, m = 5)
out1 <- getSmoothed(fit1)
plot(out1, is.subnational=FALSE)

#  subnational model
fit2 <- fitINLA(data = data, geo = geo, Amat = mat, 
  year_label = years.all, year_range = c(1985, 2019), 
  rw = 2, is.yearly=TRUE, m = 5, type.st = 4)
out2 <- getSmoothed(fit2, Amat = mat)
plot(out2, is.yearly=TRUE, is.subnational=TRUE)


}

}
\seealso{
\code{\link{plot.SUMMERproj}}
}
