% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.data_to_hist.R
\name{data_to_hist}
\alias{data_to_hist}
\title{data_to_hist}
\usage{
data_to_hist(X, Y)
}
\arguments{
\item{X}{[matrix or SparseHist]}

\item{Y}{[matrix or SparseHist]}
}
\value{
[list(muX,muY)] a list with the two SparseHist
}
\description{
Just a function to transform two datasets into SparseHist, if X or Y (or the
both) are already a SparseHist, update just the second
}
\examples{
X = base::cbind( stats::rnorm(2000) , stats::rexp(2000)  )
Y = base::cbind( stats::rexp(2000)  , stats::rnorm(2000) )

bw = base::c(0.1,0.1)
muX = SBCK::SparseHist( X , bw )
muY = SBCK::SparseHist( Y , bw )

## The four give the same result
SBCK::data_to_hist( X   , Y )
SBCK::data_to_hist( muX , Y )
SBCK::data_to_hist( X   , muY )
SBCK::data_to_hist( muX , muY )

}
