% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.RBC.R
\name{RBC}
\alias{RBC}
\title{RBC (Random Bias Correction) method}
\description{
Perform a multivariate bias correction of X with respect to Y randomly.
}
\details{
Only for comparison.
}
\examples{
## Three bivariate random variables (rnorm and rexp are inverted between ref
## and bias)
XY = SBCK::dataset_gaussian_exp_2d(2000)
X0 = XY$X0 ## Biased in calibration period
Y0 = XY$Y0 ## Reference in calibration period
X1 = XY$X1 ## Biased in projection period


## Bias correction
## Step 1 : construction of the class RBC
rbc = SBCK::RBC$new() 
## Step 2 : Fit the bias correction model
rbc$fit( Y0 , X0 , X1 )
## Step 3 : perform the bias correction
Z = rbc$predict(X1,X0) 
## Z$Z0 # BC of X0
## Z$Z1 # BC of X1
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RBC-new}{\code{RBC$new()}}
\item \href{#method-RBC-fit}{\code{RBC$fit()}}
\item \href{#method-RBC-predict}{\code{RBC$predict()}}
\item \href{#method-RBC-clone}{\code{RBC$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RBC-new"></a>}}
\if{latex}{\out{\hypertarget{method-RBC-new}{}}}
\subsection{Method \code{new()}}{
Create a new RBC object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RBC$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new `RBC` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RBC-fit"></a>}}
\if{latex}{\out{\hypertarget{method-RBC-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RBC$fit(Y0, X0, X1 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}

\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection, can be
NULL for stationary BC method}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RBC-predict"></a>}}
\if{latex}{\out{\hypertarget{method-RBC-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction. Use named keywords to use stationary or
non-stationary method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RBC$predict(X1 = NULL, X0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X1}}{[matrix: n_samples * n_features or NULL] Model in projection}

\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix or list] Return the matrix of correction of X1 if X0 is
                         NULL, else return a list containing Z1 and Z0,
                         the corrections of X1 and X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RBC-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RBC-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RBC$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
