% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imp_corr_mat.R
\name{imp_corr_mat}
\alias{imp_corr_mat}
\title{Import 'Raven' batch correlator output}
\usage{
imp_corr_mat(file, path = NULL)
}
\arguments{
\item{file}{A character string with the name of the output '.txt' file
generated by Raven.}

\item{path}{A character string indicating the path of the directory in which to look for the text files. 
If not provided (default) the function searches into the current working directory.}
}
\value{
A list with 2 matrices. The first one contains the correlation coefficients and
the second one the time lags of the peak correlations.
}
\description{
\code{imp_corr_mat} imports the output of 'Raven' batch correlator.
}
\details{
The function imports the output of a batch correlation routine in Raven. 
Both the correlation and lag matrices contained in the output '
.txt' file are read and both waveform and spectrogram (cross-correlation) correlations can be 
imported.
}
\examples{
\dontrun{ 
# Load data
library(warbleR)
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "selec.table"))

writeWave(Phae.long1, "Phae.long1.wav", extensible = FALSE) #save sound files 
writeWave(Phae.long2, "Phae.long2.wav", extensible = FALSE)
writeWave(Phae.long3, "Phae.long3.wav", extensible = FALSE)
writeWave(Phae.long4, "Phae.long4.wav", extensible = FALSE)

#create new folder to put cuts
dir.create("cuts")

# cut files
cut_sels(X = selec.table, mar = 0.05, path = tempdir(), dest.path = file.path(tempdir(), "cuts"))

#Now run 'Raven' batch correlator un the cuts and save the output in the same folder

# Import output (change the name of the file if you used a different one)
xcorr.rav <- imp_corr_mat(file = "BatchCorrOutput.txt", 
path = file.path(tempdir(), "cuts"))

# check results
  
## correlation matrix
xcorr.rav[[1]]

## time lag matrix
xcorr.rav[[2]]
}

}
\seealso{
\code{\link{imp_raven}}; \code{\link{exp_raven}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
