% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{hasAttributes}
\alias{hasAttributes}
\title{Whether SNOMED CT concepts have particular attributes}
\usage{
hasAttributes(
  sourceIds,
  destinationIds,
  typeIds = bit64::as.integer64("116680003"),
  SNOMED = getSNOMED(),
  tables = c("RELATIONSHIP", "STATEDRELATIONSHIP"),
  active_only = TRUE
)
}
\arguments{
\item{sourceIds}{character or integer64 vector of SNOMED concept IDs
for children, recycled if necessary}

\item{destinationIds}{character or integer64 vector of SNOMED concept
IDs for parents, recycled if necessary}

\item{typeIds}{character or integer64 vector of SNOMED concept IDs
for renationship types, recycled if necessary.
Defaults to 116680003 = 'Is a' (child/parent)}

\item{SNOMED}{environment containing a SNOMED dictionary}

\item{tables}{character vector of relationship tables to use}

\item{active_only}{whether only active relationships
should be considered, default TRUE}
}
\value{
a vector of Booleans stating whether the attribute exists
}
\description{
For each concept in the first list, whether it has the attribute
in the second list. Returns a vector of Booleans.
}
\examples{
SNOMED <- sampleSNOMED()

hasAttributes(c('Heart failure', 'Acute heart failure'),
  c('Heart structure', 'Heart failure'),
  c('Finding site', 'Is a'))
}
