% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Int64toInt64}
\alias{Int64toInt64}
\title{Integer64 to Integer64 round-trip demo}
\usage{
Int64toInt64(vec)
}
\arguments{
\item{vec}{An \code{integer64}-classed vector from R}
}
\value{
A modified \code{integer64} vector where each element
increased by one
}
\description{
This function takes an integer64-valued input vector, converts
it to the equivalent \code{int64_t} vector in C++, displays each
element after first adding one, and returns the modified vector.
}
\examples{
# generate all powers of 10 fro 0 .. 18
if (requireNamespace("bit64", quietly=TRUE)) {
    v <- bit64::as.integer64(10^seq(0,18))
    # pass them to function which will add one to each, print  and return
    Int64toInt64(v)
}
}
