% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_diagnostics_dimtest.R
\name{dimensionTestMap}
\alias{dimensionTestMap}
\title{Perform dimension testing on a map object}
\usage{
dimensionTestMap(
  map,
  dimensions_to_test = 1:5,
  test_proportion = 0.1,
  minimum_column_basis = "none",
  fixed_column_bases = rep(NA, numSera(map)),
  number_of_optimizations = 1000,
  replicates_per_dimension = 100,
  options = list()
)
}
\arguments{
\item{map}{The acmap data object}

\item{dimensions_to_test}{A numeric vector of dimensions to be tested}

\item{test_proportion}{The proportion of data to be used as the test set for
each test run}

\item{minimum_column_basis}{The minimum column basis to use}

\item{fixed_column_bases}{A vector of fixed column bases with NA for sera
where the minimum column basis should be applied}

\item{number_of_optimizations}{The number of optimizations to perform when
creating each map for the dimension test}

\item{replicates_per_dimension}{The number of tests to perform per dimension
tested}

\item{options}{Map optimizer options, see \code{RacOptimizer.options()}}
}
\value{
Returns a data frame with the following columns. "dimensions" : the
dimension tested, "mean_rmse_detectable" : mean prediction rmse for
detectable titers across all runs. "var_rmse_detectable" the variance of
the prediction rmse for detectable titers across all runs, useful for
estimating confidence intervals. "mean_rmse_nondetectable" and
"var_rmse_nondetectable" the equivalent for non-detectable titers
}
\description{
Take a map object and perform cross-validation, seeing how well titers are
predicted when they are excluded from the map.
}
\details{
For each run, the ag-sr titers that were randomly excluded are
predicted according to their relative positions in the map trained without
them. An RMSE is then calculated by comparing predicted titers inferred
from the map on the log scale to the actual log titers. This is done
separately for detectable titers (e.g. 40) and non-detectable titers (e.g.
<10). For non-detectable titers, if the predicted titer is the same or
lower than the log-titer threshold, the error is set to 0.
}
\seealso{
Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()},
\code{\link{triangulationBlobs}()},
\code{\link{unstableMaps}}
}
\concept{map diagnostic functions}
