% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StemID.R
\name{getproj}
\alias{getproj}
\title{Extract Projections of all Cells from a Cluster}
\usage{
getproj(object, i, show = TRUE, zscore = FALSE)
}
\arguments{
\item{object}{\code{Ltree} class object.}

\item{i}{Cluster number. This number has to correspond to one of the RaceID3 clusters included for the StemID2 inference, i.e. to a number present
in slot \code{ldata$lp}.}

\item{show}{logical. If \code{TRUE}, then plot heatmap of projections. Default is \code{TRUE}.}

\item{zscore}{logical. If \code{TRUE} and \code{show=TRUE}, then plot z-score-transformed projections. If \code{TRUE} and \code{show=FALSE},
then plot untransformed projections. Default is \code{FALSE}.}
}
\value{
A list ot two components:
  \item{pr}{a data.frame of projections for all cells in cluster \code{i} (rows) onto all other clusters (columns).}
  \item{prz}{a data.frame of z-transformed projections for all cells in cluster \code{i} (rows) onto all other clusters (columns).}
}
\description{
This function extracts projections of all cells in a cluster and plots a heatmap of these hierarchically clustered projections (rows)
to all other clusters (columns). A minimum spanning tree of the cluster centers is overlaid for comparison.
}
