% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{transitionProbs}
\alias{transitionProbs}
\title{Function for the computation of transition probabilities between clusters}
\usage{
transitionProbs(res, cl, pvalue = 0.01)
}
\arguments{
\item{res}{List object with k nearest neighbour information returned by \code{pruneKnn} function.}

\item{cl}{List object with Louvain clustering information, returned by the \code{graphCluster} function.}

\item{pvalue}{Positive real number between 0 and 1. All nearest neighbours with link probability \code{< pvalue} are discarded. Default is 0.01.}
}
\value{
Matrix of transition probabilities between clusters.
}
\description{
This function computes transition probabilities between clusters based on the link probabilities of the pruned k nearest neighbour graph.
}
\examples{
res <- pruneKnn(intestinalDataSmall,metric="pearson",knn=10,alpha=1,no_cores=1,FSelect=FALSE)
cl <- graphCluster(res,pvalue=0.01)
probs <-transitionProbs(res,cl,pvalue=0.01) 
}
