% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zplot_individual.R
\name{zooplot_individuals}
\alias{zooplot_individuals}
\title{Plot individual curves with proportion of the genome in each HBD class or cumulated
proportion in HBD classes with rates smaller than a threshold.}
\usage{
zooplot_individuals(input, cumulative = TRUE, toplot = NULL,
  ncols = 2)
}
\arguments{
\item{input}{a named list with one or several zres objects obtained after
running zoorun. The zres objects are the output of the zoorun function. For
instance, putting list(name1 = zres1, name2 = zres2). The function will then
use the names in the plot (in case several zres objects are used).}

\item{cumulative}{a logical indicating whether individual autozygosity is plotted
per class (FALSE) or summed over all HBD class with a rate smaller than a
value (these cumulated values are obtained for every rate defined in the
model). By default, this value is TRUE. When FALSE, the percentages correspond
to the individual genome-wide probabilities of belonging to each HBD-class
or to the fraction of the genome in an autozygosity class. When TRUE, we obtain
the probability of belonging to an HBD class with a rate smaller or equal than
a threshold (here we use the pre-defined rates of the model as thresholds), averaged
over the whole genome for each individual. This corresponds to report individual genomic
inbreeding coefficients estimated with respect to different base populations obtained
by selecting different thresholds T that determine which HBD classes are considered
in the estimation of the genomic inbreeding coefficient (setting the base population
approximately 0.5 * T generations ago).}

\item{toplot}{A list of vectors indicating the zres@ids to be plotted. This
option can be used to select the individuals to plot. The list must contain
one vector per population or zres object. By default, all individuals are
plotted.}

\item{ncols}{when several populations are plotted, ncols determines how many results (graphs)
are plotted per row.}
}
\value{
The function plots either the individual proportions of the genome associated with
different HBD classes or individual genomic inbreeding coefficients estimated with respect
to different base populations (from young to older). With both option, the average values are
plotted in red.
}
\description{
For each individual, the function plots the mean percentage of the genome in different
HBD classes or the inbreeding coefficient obtained by summing autozygosity associated
with HBD classes with a rate lower or equal to a threshold (e.g., including all HBD
classes with longer and more recent HBD segments than a selected threshold).
}
