% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smet-function.R
\name{smet}
\alias{smet}
\title{Function to read a  a SMET file}
\usage{
smet(file = NULL, numeric = TRUE, non_numeric_fields = NULL,
  timezone.offset.sign = c("negative", "positive", "-", "+"),
  date.field = "timestamp", date.format = "\%Y-\%m-\%dT\%H:\%M:\%S",
  comment = "#", station.field = "station_id", ...)
}
\arguments{
\item{file}{SMET file name}

\item{numeric}{logical value}

\item{non_numeric_fields}{fields, except \code{date.fiels}, that contain non-numeric values}

\item{timezone.offset.sign}{It can be \code{"negative"} or \code{"positive"}. Many systems support timezones of the form GMT+n and GMT-n, which are at a fixed offset from UTC (hence no DST). Contrary to some usage (but consistent with names such as PST8PDT), negative offsets are times ahead of (east of) UTC, positive offsets are times behind (west of) UTC.}

\item{date.field}{field neme used for date and time. Default is \code{"timestamp"}.}

\item{date.format}{format used for date and time. Default is \code{"\%Y-\%m-\%dT\%H:\%M:\%S"}.}

\item{comment}{character symbol used to comment lines or part of lines. Default is \code{"#"}. See \code{\link{str_locate}}}

\item{station.field}{field name used for station ID. Default is \code{"station_id"}, as used for \code{SMET} format.}

\item{...}{further arguments}
}
\value{
a \code{\link{smet-class}} object
}
\description{
Function to read a  a SMET file
}
\details{
To better understand the use of timezones in R (\code{tz} attribute) see the following link: 
\url{http://stackoverflow.com/questions/11927433/timezones-in-r-how-to-avoid-ambiguous-terms-such-as-est}
}
\examples{

file <- system.file("examples/test.smet",package="RSMET")
sm <- smet(file)

}
\seealso{
\code{\link{smet-class}}
}

