/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.diagnostics.CochranTest;
import ec.satoolkit.x11.DefaultExtremeValuesCorrector;
import ec.satoolkit.x11.DefaultX11Algorithm;
import ec.satoolkit.x11.IExtremeValuesCorrector;
import ec.satoolkit.x11.PeriodSpecificExtremeValuesCorrector;
import ec.tstoolkit.timeseries.simplets.TsData;

public class CochranDependentExtremeValuesCorrector
extends DefaultX11Algorithm
implements IExtremeValuesCorrector {
    private IExtremeValuesCorrector extremeValuesCorrector_;
    private DecompositionMode mode_;
    private double lsig_;
    private double usig_;
    protected boolean isexcludefcast;

    @Override
    public int analyse(TsData s) {
        this.extremeValuesCorrector_.setContext(this.context);
        this.extremeValuesCorrector_.setSigma(this.lsig_, this.usig_);
        this.extremeValuesCorrector_.setExcludefcast(this.isexcludefcast);
        return this.extremeValuesCorrector_.analyse(s);
    }

    public void testCochran(TsData s) {
        if (s.getDomain().getFullYearsCount() < 6) {
            this.extremeValuesCorrector_ = new DefaultExtremeValuesCorrector();
        } else {
            CochranTest cochranTest = new CochranTest(s, this.isMultiplicative());
            cochranTest.calcCochranTest();
            this.extremeValuesCorrector_ = cochranTest.getTestResult() ? new DefaultExtremeValuesCorrector() : new PeriodSpecificExtremeValuesCorrector();
        }
    }

    @Override
    public TsData computeCorrections(TsData s) {
        return this.extremeValuesCorrector_.computeCorrections(s);
    }

    @Override
    public TsData applyCorrections(TsData s, TsData corrections) {
        return this.extremeValuesCorrector_.applyCorrections(s, corrections);
    }

    @Override
    public TsData getObservationWeights() {
        return this.extremeValuesCorrector_.getObservationWeights();
    }

    @Override
    public TsData getCorrectionFactors() {
        return this.extremeValuesCorrector_.getCorrectionFactors();
    }

    @Override
    public void setSigma(double lsig, double usig) {
        this.lsig_ = lsig;
        this.usig_ = usig;
    }

    public void setMode(DecompositionMode mode) {
        this.mode_ = mode;
    }

    @Override
    public void setExcludefcast(boolean isExcludefcast) {
        this.isexcludefcast = isExcludefcast;
    }

    @Override
    public boolean getExcludefcast() {
        return this.isexcludefcast;
    }
}

