% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KWPrimal.R
\name{KWPrimal}
\alias{KWPrimal}
\title{Primal optimization for Kiefer-Wolfowitz problems}
\usage{
KWPrimal(A, d, w, ...)
}
\arguments{
\item{A}{Linear constraint matrix}

\item{d}{constraint vector}

\item{w}{weights for \code{x} should sum to one.}

\item{...}{other parameters passed to control optimization:  These may
include \code{rtol} the relative tolerance for dual gap convergence criterion,
\code{verb} to control verbosity desired from mosek, \code{verb = 0} is quiet,
\code{verb = 5} produces a fairly detailed iteration log,
\code{control} is a control list consisting of sublists \code{iparam},
\code{dparam}, and \code{sparam}, containing elements of various mosek
control parameters.  See the Rmosek and Mosek manuals for further details.
A prime example is \code{rtol} which should eventually be deprecated and
folded into \code{control}, but will persist for a while for compatibility
reasons.  The default for \code{rtol} is 1e-6, but in some cases it is
desirable to tighten this, say to 1e-10.  Another example that motivated the introduction of
\code{control} would be \code{control = list(iparam = list(num_threads =
1))}, which forces Mosek to use a single threaded process.  The default
allows Mosek to uses multiple threads (cores) if available, which is
generally desirable, but may have unintended (undesirable) consequences when running
simulations on clusters.}
}
\value{
Returns a list with components: \item{f}{primal solution vector, the
mixing density} \item{g}{the mixture density
evaluated at the data points} \item{logLik}{log likelihood}
\item{status}{return status from Mosek}.  Mosek termination messages are
treated as warnings from an R perspective since solutions producing, for example,
MSK_RES_TRM_STALL: The optimizer is terminated due to slow progress, may still
provide a satisfactory solution, especially when the return status variable is
"optimal".
}
\description{
Interface function for calls to optimizer from various REBayes functions
There is currently only one option for the optimization that based on  Mosek. 
It relies on the \pkg{Rmosek} interface to R see installation instructions in
the Readme file in the inst directory of this package.  This version of the function
works only with versions of Mosek 9.0.  This is an experimental alternative to the
main KWDual which is the usual interface from fitting functions to Mosek, caveat emptor..
}
\references{
Koenker, R and I. Mizera, (2013) ``Convex Optimization, Shape Constraints,
Compound Decisions, and Empirical Bayes Rules,'' \emph{JASA}, 109, 674--685.

Mosek Aps (2015) Users Guide to the R-to-Mosek Optimization Interface, 
\url{https://docs.mosek.com/8.1/rmosek/index.html}.  

Koenker, R. and J. Gu, (2017) REBayes: An {R} Package for Empirical Bayes Mixture Methods,
\emph{Journal of Statistical Software}, 82, 1--26.
}
\author{
R. Koenker
}
\keyword{nonparametrics}
