% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_fits.R
\name{flFitLinear}
\alias{flFitLinear}
\title{Data fit via a heuristic linear method}
\usage{
flFitLinear(
  time = NULL,
  growth = NULL,
  fl_data,
  ID = "undefined",
  quota = 0.95,
  control = fl.control(x_type = c("growth", "time"), log.x.lin = FALSE, log.y.lin =
    FALSE, t0 = 0, min.growth = NA, lin.h = NULL, lin.R2 = 0.98, lin.RSD = 0.05, lin.dY =
    0.05, biphasic = FALSE)
)
}
\arguments{
\item{time}{Vector of the independent time variable (if x_type = "time" in control object).}

\item{growth}{Vector of the independent time growth (if x_type = "growth" in control object).}

\item{fl_data}{Vector of the dependent fluorescence variable.}

\item{ID}{(Character) The name of the analyzed sample.}

\item{quota}{(Numeric, between 0 an 1) Define what fraction of \code{max_slope} the slope of regression windows adjacent to the window with highest slope should have to be included in the overall linear fit.}

\item{control}{A \code{fl.control} object created with \code{\link{fl.control}}, defining relevant fitting options.}
}
\value{
A \code{gcFitLinear} object with parameters of the fit. The lag time is
estimated as the intersection between the fit and the horizontal line with
\eqn{y=y_0}, where \code{y0} is the first value of the dependent variable.
Use \code{\link{plot.gcFitSpline}} to visualize the linear fit.
\item{raw.x}{Filtered x values used for the spline fit.}
\item{raw.fl}{Filtered fluorescence values used for the spline fit.}
\item{filt.x}{Filtered x values.}
\item{filt.fl}{Filtered fluorescence values.}
\item{ID}{(Character) Identifies the tested sample.}
\item{FUN}{Linear \emph{function} used for plotting the tangent at mumax.}
\item{fit}{\code{lm} object; result of the final call of \code{\link{lm}} to perform the linear regression.}
\item{par}{List of determined fluorescence parameters.}
\itemize{
\item \code{y0}: {Minimum fluorescence value considered for the heuristic linear method.}
\item \code{dY}: {Difference in maximum fluorescence and minimum fluorescence}
\item \code{A}: {Maximum fluorescence}
\item \code{y0_lm}: {Intersection of the linear fit with the abscissa.}
\item \code{max_slope}: {Maximum slope of the linear fit.}
\item \code{tD}: {Doubling time.}
\item \code{slope.se}: {Standard error of the maximum slope.}
\item \code{lag}: {Lag X.}
\item \code{x.max_start}: {X value of the first data point within the window used for the linear regression.}
\item \code{x.max_end}: {X value of the last data point within the window used for the linear regression.}
\item \code{x.turn}: {For biphasic: X at the inflection point that separates two phases.}
\item \code{max.slope2}: {For biphasic: Slope of the second phase.}
\item \code{tD2}: {Doubling time of the second phase.}
\item \code{y0_lm2}: {For biphasic: Intersection of the linear fit of the second phase with the abscissa.}
\item \code{lag2}: {For biphasic: Lag time determined for the second phase..}
\item \code{x.max2_start}: {For biphasic: X value of the first data point within the window used for the linear regression of the second phase.}
\item \code{x.max2_end}: {For biphasic: X value of the last data point within the window used for the linear regression of the second phase.}
}
\item{ndx}{Index of data points used for the linear regression.}
\item{ndx2}{Index of data points used for the linear regression for the second phase.}
\item{control}{Object of class \code{grofit.control} containing list of options passed to the function as \code{control}.}
\item{rsquared}{\ifelse{html}{\out{R<sup>2</sup>}}{\eqn{R^2}} of the linear regression.}
\item{rsquared2}{\ifelse{html}{\out{R<sup>2</sup>}}{\eqn{R^2}} of the linear regression for the second phase.}
\item{fitFlag}{(Logical) Indicates whether linear regression was successfully performed on the data.}
\item{fitFlag2}{(Logical) Indicates whether a second phase was identified.}
\item{reliable}{(Logical) Indicates whether the performed fit is reliable (to be set manually).}
}
\description{
Determine maximum slopes from using a heuristic approach similar to the ``growth rates made easy''-method of
Hall et al. (2013).
}
\examples{
# load example dataset
input <- read_data(data.growth = system.file("lac_promoters.xlsx", package = "QurvE"),
                   data.fl = system.file("lac_promoters.xlsx", package = "QurvE"),
                   sheet.growth = 1,
                   sheet.fl = 2 )

# Extract time and normalized fluorescence data for single sample
time <- input$time[4,]
data <- input$norm.fluorescence[4,-(1:3)] # Remove identifier columns

# Perform linear fit
TestFit <- flFitLinear(time = time,
                       fl_data = data,
                       ID = "TestFit",
                       control = fl.control(fit.opt = "l", x_type = "time",
                       lin.R2 = 0.95, lin.RSD = 0.1,
                       lin.h = 20))

plot(TestFit)
}
\references{
Hall, BG., Acar, H, Nandipati, A and Barlow, M (2014) Growth Rates Made Easy. Mol. Biol. Evol. 31: 232-38, DOI: 10.1093/molbev/mst187

Petzoldt T (2022). \emph{growthrates: Estimate Growth Rates from Experimental Data}. R package version 0.8.3, \url{https://CRAN.R-project.org/package=growthrates}.
}
