% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{pkbc_validation}
\alias{pkbc_validation}
\title{Validation of Poisson kernel-based clustering results}
\usage{
pkbc_validation(object, true_label = NULL, h = 1.5)
}
\arguments{
\item{object}{Object of class \code{pkbc}}

\item{true_label}{factor or vector of true membership to clusters (if
available). It must have the same length of final
memberships.}

\item{h}{Tuning parameter of the k-sample test. (default: 1.5)}
}
\value{
List with the following components:
\itemize{
\item \code{metrics} Table of computed evaluation measures.
\item \code{IGP} List of in-group proportions for each value of number of
clusters specified.
}
}
\description{
Method for objects of class \code{pkbc} which computes evaluation measures
for clustering results.
}
\details{
The following evaluation measures are computed:
In-Group Proportion. If true label are provided, ARI, Average
Silhouette Width, Macro-Precision and Macro-Recall are computed.
}
\examples{
#We generate three samples of 100 observations from 3-dimensional
#Poisson kernel-based densities with rho=0.8 and different mean directions
\donttest{
size<-20
groups<-c(rep(1, size), rep(2, size),rep(3,size))
rho<-0.8
set.seed(081423)
data1<-rpkb(size, c(1,0,0),rho,method='rejvmf')
data2<-rpkb(size, c(0,1,0),rho,method='rejvmf')
data3<-rpkb(size, c(1,0,0),rho,method='rejvmf')
data<-rbind(data1$x,data2$x, data3$x)

#Perform the clustering algorithm
pkbc_res<- pkbc(data, 2:4)
pkbc_validation(pkbc_res)
}

}
\references{
Kapp, A.V., Tibshirani, R. (2007) "Are clusters found in one dataset present
in another dataset?", Biostatistics, 8(1), 9–31,
https://doi.org/10.1093/biostatistics/kxj029

Rousseeuw, P.J. (1987) Silhouettes: A graphical aid to the interpretation and
validation of cluster analysis. Journal of Computational and Applied
Mathematics, 20, 53–65.
}
