% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_Pvalue_S}
\alias{get_Pvalue_S}
\title{Get perturbed p-value.}
\usage{
get_Pvalue_S(module, freq_matrix, sur, perms = 1000, local_network)
}
\arguments{
\item{module}{The candidate module,generated by `get_candidate_module`.}

\item{freq_matrix}{The mutations matrix,generated by `get_mut_status`.}

\item{sur}{A nx2 data frame of samples' survival data,the first line is samples' survival event and the second line is samples' overall survival.}

\item{perms}{The perturbation number,default is 1000.}

\item{local_network}{The local network gene sets,generated by `get_local_network`.}
}
\value{
Perturbed p-value.
}
\description{
The function `get_Pvalue_S` is used to calculate the perturbed p-value.
}
\examples{
\donttest{#load the data
data(local_network)
data(mut_status)
data(candidate_module)
sur<-system.file("extdata","sur.csv",package = "ProgModule")
sur<-read.delim(sur,sep=",",header=TRUE,row.names = 1)
#perform the function `get_Pvalue_S`.
turbulence.example<-get_Pvalue_S(module=candidate_module,freq_matrix=mut_status,
sur=sur,perms=100,local_network)}
}
