% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{transferGeneNames}
\alias{transferGeneNames}
\title{Transfer gene names from one fortmat to the other format}
\usage{
transferGeneNames(
  genelist,
  now_name = "ensembl",
  to_name = "symbol",
  species = c("Human", "Mouse"),
  Method = c("eg.db", "biomart")
)
}
\arguments{
\item{genelist}{a string vector, the gene list to be transferred.}

\item{now_name}{a string, the current format of gene names, one of 'ensembl', 'symbol'.}

\item{to_name}{a string, the  format of gene names to transfer, one of 'ensembl', 'symbol'.}

\item{species}{a string, the species, one of 'Human' and 'Mouse'.}

\item{Method}{a string, the method to use, one of 'biomaRt' and 'eg.db', default as 'eg.db'.}
}
\value{
Return a string vector of transferred gene names. The gene names not matched in the database will not change.
}
\description{
Transfer gene names from one fortmat to the other format for two species: human and mouse.
}
\examples{
geneNames <- c("ENSG00000171885", "ENSG00000115756")
transferGeneNames(geneNames, now_name = "ensembl", to_name="symbol",species="Human", Method='eg.db')


}
