% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_data_processing.R
\name{products}
\alias{products}
\title{Detecting and summarising available, matched, new and disappearing products.}
\usage{
products(data, start, end)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01') and \code{prodID} (as numeric, factor or character).}

\item{start}{The base period (as character) limited to the year and month, e.g. "2020-03".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2020-04".}
}
\value{
This function detects and summarises available, matched, new and disappearing products on the basis of their prodIDs. It compares products from the base period (\code{start}) with products from the current period (\code{end}). It returns a list containing the following objects: \code{details} with prodIDs of available, matched, new and disappearing products, \code{statistics} with basic statistics for them and \code{figure} with a pie chart describing a contribution of matched, new and disappearing products in a set of available products.
}
\description{
This function detects and summarises available, matched, new as well as disappearing products on the basis of their prodIDs.
}
\examples{
\donttest{list<-products(milk, "2018-12","2019-12")
list$details
list$statistics
list$figure
}
}
