% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_docs.R
\name{shelter.listByBreed}
\alias{shelter.listByBreed}
\title{Returns a data.frame of shelter IDs listing animals matching the input animal breed.}
\usage{
shelter.listByBreed(animal, breed, offset = NULL, count = NULL,
  pages = NULL)
}
\arguments{
\item{animal}{Return breeds of animal. Must be one of 'barnyard', 'bird',
'cat', 'dog', 'horse', 'reptile', or 'smallfurry'.}

\item{breed}{Specifies the breed of the animal to search.}

\item{offset}{Can be set to the value of lastOffset returned from the previous call to retrieve the next set of results. The pages parameter can also be used to pull a desired number of paged results.}

\item{count}{The number of records to return. Default is 25.}

\item{pages}{The number of pages of results to return. For example, if 
pages=4 with the default count parameter (25), 125 results would be 
returned (25 results from first call and 100 from the next four pages).}
}
\value{
data.frame of pet records associated with specified shelterId.
}
\description{
Returns a data.frame of shelter IDs listing animals matching the input animal breed.
}
\examples{
\dontrun{
pf <- Petfinder(key) # Initialize Petfinder class
pf$shelter.listByBreed('cat', 'Abyssinian')
pf$shelter.listByBreed('dog', 'Golden Retriever')
}
}
