% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gen.R
\name{Gen}
\alias{Gen}
\title{Balanced Incomplete binary Blocks Designs of second Generation.}
\usage{
Gen(n, mat)
}
\arguments{
\item{n}{The sub-variety of the block to be deleted.}

\item{mat}{The matrix of the BIB.}
}
\value{
A LIST of:
\enumerate{
 \item \code{V }{Number of treatments in the BIBD.}
 \item \code{B }{Number of blocks of the BIBD.}
 \item \code{R }{Repetition of each treatment.}
 \item \code{K }{Size of each block.}
 \item \code{BIB }{The configuration of the BIBD.}
}
}
\description{
Gives the configuration of a Balanced Incomplete binary Blocks
Designs of seconde generation.
}
\examples{
\dontrun{
m<-4
X<-BIB(m)   #BIB from PG(4,2)

n<-1
mat<-X$BIB
X2<-Gen(n,mat) #Extracts the BIB second generation
}
}
\author{
Mohamed Laib, Abla Boudraa and Zebida Gheribi-Aoulmi
}
\references{
D. Dugué Traité de statistique théorique et appliquée, Masson et Cie, 1958.
}

