% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCfacstuffzzz.R
\name{MCMCpanic04}
\alias{MCMCpanic04}
\title{PANIC (2004) MCMC Non-Stationarity Tests on Common and Idiosyncratic Components}
\usage{
MCMCpanic04(x, nfac, k1, criteria = NULL,burn = 1000,
mcmc = 10000, thin = 10, verbose = 0, seed = NA,
lambda.start = NA, psi.start = NA, l0 = 0, L0 = 0, 
a0 = 0.001, b0 = 0.001, std.var = TRUE,...)
}
\arguments{
\item{x}{An object of class xts with each column being a time series}

\item{nfac}{An integer specifying the maximum number of factors allowed
while estimating the factor model.}

\item{k1}{an integer that is the maximum lag allowed in the ADF test.}

\item{criteria}{a character vector of length one with a value of either
IC1, IC2, IC3, AIC1, BIC1, AIC3, BIC3, or eigen. Choosing eigen makes
the number of factors equal to the number of columns whose sum of
eigenvalues is less than  or equal to .5.}

\item{burn}{Integer of the number of burn in iterators for the sampler}

\item{mcmc}{Integer of the number of iterations in the sampler}

\item{thin}{Integer of the thinning interval used in the simulation. mcmc must be divisible by this value.}

\item{verbose}{A positive integer which determines whether or not the progress of the
sampler is printed to the screen. If verbose is greater than 0 the iteration 
number and the factor loadings and uniquenesses are printed to the screen 
every verboseth iteration.}

\item{seed}{The seed for the random number generator.}

\item{lambda.start}{Starting values for the factor loading matrix Lambda.}

\item{psi.start}{Starting values for the uniqueness}

\item{l0}{The means of the independent Normal prior on the factor loadings}

\item{L0}{A scalar or a matrix with the same dimensions as lambda. The precision (inverse variances)
of the independent Normal prior on the factor loadings.}

\item{a0}{scalar or a k-vector. Controls the shape of the inverse Gamma prior on the uniqueness.}

\item{b0}{Controls the scale of the inverse Gamma prior on the uniqueness.}

\item{std.var}{if TRUE the variables are rescaled to have zero mean and unit variance.
Otherwise, the variables are rescaled to have zero mean, but retain their observed variances}

\item{...}{extra parameters to pass to MCMCfactanal}
}
\value{
mcmc_tests An mcmc object containing the resampled tests on the common components as well as
the test on the idiosyncratic component.

factor_mcmc The results from MCMCfactanal()
}
\description{
This function performs an MCMC over the 
tests on the idiosyncratic and common component from PANIC (2004).
}
\references{
Bai, Jushan, and Serena Ng. 
'A PANIC Attack on Unit Roots and Cointegration.'
Econometrica 72.4 (2004): 1127-1177. Print.

Andrew D. Martin, Kevin M. Quinn, Jong Hee Park (2011). MCMCpack: Markov Chain Monte Carlo
in R. Journal of Statistical Software. 42(9): 1-21. URL http://www.jstatsoft.org/v42/i09/.
}

