% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_getLocationID.R
\name{table_getLocationID}
\alias{table_getLocationID}
\title{Return IDs of known locations}
\usage{
table_getLocationID(
  locationTbl = NULL,
  longitude = NULL,
  latitude = NULL,
  distanceThreshold = NULL,
  measure = "geodesic"
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{longitude}{Vector of longitudes in decimal degrees E.}

\item{latitude}{Vector of latitudes in decimal degrees N.}

\item{distanceThreshold}{Distance in meters.}

\item{measure}{One of "haversine" "vincenty", "geodesic", or "cheap" 
specifying desired method of geodesic distance calculation. See \code{?geodist::geodist}.}
}
\value{
Vector of known \code{locationID}s.
}
\description{
Returns a vector of \code{locationID}s for the known locations
that each incoming location will be assigned to within the given. If more
than one known location exists within the given \code{distanceThreshold}, the closest will be
assigned.  \code{NA} will be returned for each incoming that cannot be 
assigned to a known location in \code{locationTbl}.
}
\note{
The measure \code{"cheap"} may be used to speed things up depending on
the spatial scale being considered. Distances calculated with 
\code{measure = "cheap"} will vary by a few meters compared with those 
calculated using \code{measure = "geodesic"}.
}
\examples{
locationTbl <- get(data("wa_monitors_500"))

# Wenatchee
lon <- -120.325278
lat <- 47.423333

# Too small a distanceThreshold will not find a match
table_getLocationID(locationTbl, lon, lat, distanceThreshold = 50)

# Expanding the distanceThreshold will find one
table_getLocationID(locationTbl, lon, lat, distanceThreshold = 5000)
}
