% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PN-epiSEIR-node-P.R
\name{spn_P_epiSEIR_node}
\alias{spn_P_epiSEIR_node}
\title{Make Places (P) For a Node (SEI Mosquitoes - SEIR Humans)}
\usage{
spn_P_epiSEIR_node(params, cube)
}
\arguments{
\item{params}{a named list of parameters (see details)}

\item{cube}{an inheritance cube from the \code{MGDrivE} package (e.g. \code{\link[MGDrivE]{cubeMendelian}})}
}
\value{
a list with two elements: \code{ix} contains labeled indices of the
places by life stage, \code{u} is the character vector of places (P)
}
\description{
This function makes the set of places (P) for a SPN. It is used alone if our
model is a single-node metapopulation for mosquito SEI and human SEIR dynamics;
otherwise it is used as part of other functions to make SPN models with larger
state spaces (metapopulation models, \code{\link{spn_P_epiSEIR_network}}).
}
\details{
The \code{params} argument supplies all of the ecological parameters necessary
to calculate equilibrium values. This function requires the \code{nE},
\code{nL}, \code{nP}, and \code{nEIP} parameters to be specified. For more details, see
\code{\link{equilibrium_SEI_SEIR}}

For examples of using this function, see:
\code{vignette("seir-dynamics", package = "MGDrivE2")}
}
