% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCplot.R
\name{MCMCplot}
\alias{MCMCplot}
\title{Caterpillar plots of posterior distributions from MCMC output}
\usage{
MCMCplot(object, params = "all", excl = NULL, ref = 0, ref_ovl = TRUE,
  rank = FALSE, xlim, ylim, xlab, main, labels, labels_sz = 1.2,
  med_sz = 1.5, thick_sz = 5, thin_sz = 2, ax_sz = 3,
  x_axis_text_sz = 1.3, x_tick_text_sz = 1.2, main_text_sz = 1.2,
  tick_pos, mar = c(5.1, 4.1, 4.1, 2.1))
}
\arguments{
\item{object}{Object containing MCMC output. See DETAILS below.}

\item{params}{Character string (or vector of character strings) denoting parameters to be
plotted. Partial names may be used to plot all parameters containing that set of characters.

Default \code{'all'} plots posteriors for all parameters. See VALUE below.

Valid entries are \code{jags_object}, \code{mcmc_list}, and \code{chains}. See DETAILS below.}

\item{excl}{Character string (or vector of character strings) denoting parameters to exclude.
Partical names may be used to exclude all parameters contaiing that set of characters. Used in
conjunction with \code{params} argument to select parameters of interest.}

\item{ref}{Numerical vector indicating where vertical reference line should be created.

Default is \code{ref = 0}.

Argument \code{NULL} will plot no reference line.}

\item{ref_ovl}{Logical specifying whether the style/color of plotted median dots and CI should
be changed based on whether the 50% and 95% credible intervals overlap the reference line. See
DETAILS for more information.}

\item{rank}{If \code{TRUE} posteriors will ranked in decreasing order (based on
specified measure of centrality) from top down.}

\item{xlim}{Numerical vector of length 2, indicating range of x-axis.}

\item{ylim}{Numerical vector of length 2, indicating range of y-axis}

\item{xlab}{Character string labeling x-axis.

Option \code{NULL} will return plot with no labels on y-axis.}

\item{main}{Character string indicating title of plot.}

\item{labels}{Character string (or vector of character strings if plotting > 1 parameter) labeling
parameter estimates along y-axis.

Specifying labels in the argument will use these to label parameter estimates on y-axis.

Default option will use parameter names from \code{object}.

Option \code{NULL} will return plot with no labels on y-axis.}

\item{labels_sz}{Number specifying size of text for parameter labels on y-axis.}

\item{med_sz}{Number specifying size of points represents posterior medians.}

\item{thick_sz}{Number specifying thickness of 50 percent CI line (thicker line).}

\item{thin_sz}{Number specifying thickness of 95 percent CI line (thinner line).}

\item{ax_sz}{Number specifying thickness of x-axis and ticks.}

\item{x_axis_text_sz}{Number specifying size of text for x-axis label.}

\item{x_tick_text_sz}{Number specifying size of text for tick labels on x-axis.}

\item{main_text_sz}{Number specifying size of text for main title.}

\item{tick_pos}{Numeric vector specifying where ticks on x-axis should be placed.}

\item{mar}{Numerical vector of length 4 specifying plot margins - (BOTTOM, LEFT, TOP, RIGHT).
Changes to the margin should be made within the function rather than using the \code{par} call.

Default is c(5.1, 4.1, 4.1, 2.1) - the R plot default.}
}
\description{
Visualize posterior distributions from MCMC output for specific parameters of interest using
caterpillar plots. Color of median dot represents relationship of parameter to reference line
(default is 0; see DETAILS below).
}
\section{Details}{

Points represent posterior medians. For parameters where 50% credible intervals overlap 0 are indicated by 'open'
circles. For parameters where 50 percent credible intervals DO NOT overlap 0 AND 95 percent credible intervals DO
overlap 0 are indicated by 'closed' grey circles. For parameters where 95 percent credible intervals DO NOT overlap
0 are indicated by 'closed' black circles. Thick lines represent 50 percent credible intervals while thin lines
represent 95 percent credible intervals. \code{ref_ovl = FALSE} can be used to disable this feature. All median dots
will be represented as 'closed' black circles.

\code{object} argument can be a \code{stanfit} object (\code{rstan} package), an \code{mcmc.list} object
(\code{coda} package), an \code{R2jags} model object (\code{R2jags} package), or a matrix containing MCMC
chains (each column representing MCMC output for a single parameter, rows representing iterations in the chain).
The function automatically detects the object type and proceeds accordingly.
}

\section{Notes}{


When specifying \code{rank = TRUE} and specifying labels for \code{labels}, labels will be applied to parameters before
they are ranked.

Thanks to Cinner et al. 2016, whose Fig. 1 inspired this plot.
}

\section{References}{


Cinner, J. E., C. Huchery, M. A. MacNeil, N. A. J. Graham, T. R. McClanahan, J. Maina, E. Maire, J.
N. Kittinger, C. C. Hicks, C. Mora, E. H. Allison, S. D'Agata, A. Hoey, D. A. Feary, L. Crowder, I.
D. Williams, M. Kulbicki, L. Vigliola, L. Wantiez, G. Edgar, R. D. Stuart-Smith, S. A. Sandin, A.
L. Green, M. J. Hardt, M. Beger, A. Friedlander, S. J. Campbell, K. E. Holmes, S. K. Wilson, E.
Brokovich, A. J. Brooks, J. J. Cruz-Motta, D. J. Booth, P. Chabanet, C. Gough, M. Tupper, S. C. A.
Ferse, U. R. Sumaila, and D. Mouillot. 2016. Bright spots among the world's coral reefs. Nature
535:416-419.
}
\examples{
#Load data
data(MCMC_data)

#Plot MCMC output
MCMCplot(MCMC_data, labels=NULL)

#Just 'beta' parameters
MCMCplot(MCMC_data, params= 'beta')

#Just 'beta[1]', 'gamma[4]', and 'alpha[3]'
MCMCplot(MCMC_data, params= c('beta[1]', 'gamma[4]', 'alpha[3]'))

#Rank parameters by posterior mean
MCMCplot(MCMC_data, params= 'beta', rank=TRUE)

}

