% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_TLLxTxRatio.R
\name{calc_TLLxTxRatio}
\alias{calc_TLLxTxRatio}
\title{Calculate the Lx/Tx ratio for a given set of TL curves [beta version]}
\usage{
calc_TLLxTxRatio(Lx.data.signal, Lx.data.background, Tx.data.signal,
  Tx.data.background, signal.integral.min, signal.integral.max)
}
\arguments{
\item{Lx.data.signal}{\code{\linkS4class{RLum.Data.Curve}} or
\code{\link{data.frame}} (\bold{required}): TL data (x =
temperature, y = counts) (TL signal)}

\item{Lx.data.background}{\code{\linkS4class{RLum.Data.Curve}} or
\code{\link{data.frame}} (optional): TL data (x =
temperature, y = counts). If no data are provided no background subtraction
is performed.}

\item{Tx.data.signal}{\code{\linkS4class{RLum.Data.Curve}} or
\code{\link{data.frame}} (\bold{required}): TL data (x =
temperature, y = counts) (TL test signal)}

\item{Tx.data.background}{\code{\linkS4class{RLum.Data.Curve}} or
\code{\link{data.frame}} (optional): TL data (x =
temperature, y = counts). If no data are provided no background subtraction
is performed.}

\item{signal.integral.min}{\code{\link{integer}} (\bold{required}): channel number
for the lower signal integral bound (e.g. \code{signal.integral.min = 100})}

\item{signal.integral.max}{\code{\link{integer}} (\bold{required}): channel number
for the upper signal integral bound (e.g. \code{signal.integral.max = 200})}
}
\value{
Returns an S4 object of type \code{\linkS4class{RLum.Results}}.
Slot \code{data} contains a \link{list} with the following structure:\cr\cr
$ LxTx.table \cr .. $ LnLx \cr .. $ LnLx.BG \cr .. $ TnTx \cr .. $ TnTx.BG
\cr .. $ Net_LnLx \cr .. $ Net_LnLx.Error\cr
}
\description{
Calculate Lx/Tx ratio for a given set of TL curves.
}
\details{
\bold{Uncertainty estimation}\cr

The standard errors are calculated using the following generalised equation:

\deqn{SE_{signal} <- abs(Signal_{net} * BG_f /BG_{signal}}

where \eqn{BG_f} is a term estimated by calculating the standard deviation of the sum of
the \eqn{L_x} background counts and the sum of the \eqn{T_x} background counts. However,
if both signals are similar the error becomes zero.
}
\note{
\bold{This function has still BETA status!} Please further note that a similar
background for both curves results in a zero error.
}
\section{Function version}{
 0.3.0 (2017-01-26 14:08:57)
}

\examples{


##load package example data
data(ExampleData.BINfileData, envir = environment())

##convert Risoe.BINfileData into a curve object
temp <- Risoe.BINfileData2RLum.Analysis(TL.SAR.Data, pos = 3)


Lx.data.signal <- get_RLum(temp, record.id=1)
Lx.data.background <- get_RLum(temp, record.id=2)
Tx.data.signal <- get_RLum(temp, record.id=3)
Tx.data.background <- get_RLum(temp, record.id=4)
signal.integral.min <- 210
signal.integral.max <- 230

output <- calc_TLLxTxRatio(Lx.data.signal,
                           Lx.data.background,
                           Tx.data.signal, Tx.data.background,
                           signal.integral.min, signal.integral.max)
get_RLum(output)

} 

\section{How to cite}{
Kreutzer, S., Schmidt, C. (2017). calc_TLLxTxRatio(): Calculate the Lx/Tx ratio for a given set of TL curves [beta version]. Function version 0.3.0. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.1. https://CRAN.R-project.org/package=Luminescence
}

\references{
-
}
\seealso{
\code{\linkS4class{RLum.Results}}, \code{\link{analyse_SAR.TL}}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France), Christoph Schmidt, University of Bayreuth (Germany)
\cr R Luminescence Package Team}
\keyword{datagen}
