% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_RLum.R
\docType{methods}
\name{smooth_RLum}
\alias{smooth_RLum}
\alias{smooth_RLum,list-method}
\title{Smoothing of data}
\usage{
smooth_RLum(object, ...)

\S4method{smooth_RLum}{list}(object, ...)
}
\arguments{
\item{object}{\code{\linkS4class{RLum}} (\bold{required}): S4 object of
class \code{RLum}}

\item{...}{further arguments passed to the specifc class method}
}
\value{
An object of the same type as the input object is provided
}
\description{
Function calls the object-specific smooth functions for provided RLum S4-class objects.
}
\details{
The function provides a generalised access point for specific
\code{\linkS4class{RLum}} objects.\cr Depending on the input object, the
corresponding function will be selected. Allowed arguments can be found
in the documentations of the corresponding \code{\linkS4class{RLum}} class. The smoothing
is based on an internal function called \code{.smoothing}.
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: Returns a list of \code{\linkS4class{RLum}} objects that had been passed to \code{\link{smooth_RLum}}
}}

\note{
Currenlty only \code{RLum} objects of class \code{RLum.Data.Curve} and \code{RLum.Analysis} (with curve data) are supported!
}
\section{Function version}{
 0.1.0 (2017-01-24 21:10:47)
}

\examples{

##load example data
data(ExampleData.CW_OSL_Curve, envir = environment())

##create RLum.Data.Curve object from this example
curve <-
  set_RLum(
      class = "RLum.Data.Curve",
      recordType = "OSL",
      data = as.matrix(ExampleData.CW_OSL_Curve)
  )

##plot data without and with smoothing
plot_RLum(curve)
plot_RLum(smooth_RLum(curve))

}
\seealso{
\code{\linkS4class{RLum.Data.Curve}}, \code{\linkS4class{RLum.Analysis}}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team} 

\section{How to cite}{
Kreutzer, S. (2017). smooth_RLum(): Smoothing of data. Function version 0.1.0. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.0. https://CRAN.R-project.org/package=Luminescence
}

\keyword{utilities}
