\name{StatReserveList}
\alias{StatReserveList}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
StatReserveList
}
\description{
This function computes several statistics on the reserve.list (see function findCluster). 
}
\usage{
StatReserveList(reserve.list, dat)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{reserve.list}{
list containing the information on the reserve list. It is the output of the findClusters function. Each component of the list should contain (at least): the type of assignment to the reserve list, the iteration number, the cluster dissolved to be assigned to the reserve list and its validity, the community assigned to the reserve list. See function findClusters.
}
  \item{dat}{
data.frame/data.table containing the commuting data. Each row corresponds to an observation, i.e. a flow, and each column corresponds to a variable. The variables are named: community_live: (integer) contains the id number of the elementary zone of residence, community_work:  (integer) contains the id number of the working community (elementary zone of work), amount: (numeric) contains the number of employees commuting between the "community_live" and "community_work" (direction is important). Missing values (NAs) are not allowed. The community id must be strictly positive. Negative flows are not allowed.
}
}
\value{
A list with the following components:
\item{NumComm}{integer; number of communities in the reserve list}
\item{NumClus}{integer; as each community in the reserve list initially belonged to a cluster, this statistics reports the number of different clusters in the reserve list. The clusters ID are the ones initially generated by the algorithm.}
\item{NumUniqueClus}{integer; number of clusters (for communities in the reserve list) with a unique community.}
\item{summaryCommByClus}{numeric vector; summary statistics on the number of communities, by cluster. Only the communities included in the reserve list are considered.}
\item{summaryValidities}{numeric vector; summary statistics on validity values of the clusters when they were considered for the reserve.list.}
\item{TypesTable}{frequency table of the types of assignment of the communities to the reserve list.}
\item{Residents}{data.table of two columns: communities in the reserve list and their residents.}
\item{summaryResidByComm}{numeric vector; summary statistics on the number of residents by community in the reserve list.}
\item{Workers}{data.table of two columns: communities in the reserve list and their jobs.}
\item{summaryWorkersByCom}{numeric vector; summary statistics on the number of workers by community in the reserve list.}
}
\author{
Daniela Ichim, Luisa Franconi, Michele D'Alo'
}
\seealso{
findClusters
}

\references{
[1] Franconi, L., D'Alo' M. and Ichim, D. (2016). Istat implementation of the algorithm to develop Labour Market Areas.
}
