/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Compile;

import jas.AsciiCP;
import jas.CP;
import jas.ClassCP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.FieldCP;
import jas.Insn;
import jas.MethodCP;
import jas.RuntimeConstants;
import jas.Var;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import org.omegahat.Environment.Interpreter.BasicEvaluator;
import org.omegahat.Environment.Parser.Parse.Name;
import org.omegahat.Environment.System.Globals;

public class DynamicCompiler
implements RuntimeConstants {
    public static int GET = 1;
    public static int SET = 2;
    public static int BOTH = 3;
    protected File output;
    protected String className;
    protected String packageName;
    protected ClassEnv classDef;
    protected boolean debug = false;
    protected String superClassName = "java/lang/Object";

    public DynamicCompiler() {
    }

    public DynamicCompiler(ClassEnv classEnv) {
        this.classDef(classEnv);
    }

    public DynamicCompiler(String string) {
        this(string, null);
    }

    public DynamicCompiler(String string, String string2) {
        this(string, string2, "java/lang/Object");
    }

    public DynamicCompiler(String string, String string2, String string3) {
        this.className(string);
        this.packageName(string2);
        this.superClassName(string3);
    }

    public DynamicCompiler(String string, String string2, boolean bl) {
        this(string, null, string2);
    }

    public boolean Debug() {
        return this.debug;
    }

    public boolean Debug(boolean bl) {
        this.debug = bl;
        return this.Debug();
    }

    public CodeAttr accessorBody(String string, String string2, boolean bl, boolean bl2) {
        CodeAttr codeAttr = new CodeAttr();
        codeAttr.setStackSize((short)4);
        codeAttr.setVarSize((short)4);
        return this.accessorBody(string, string2, bl, bl2, codeAttr);
    }

    public CodeAttr accessorBody(String string, String string2, boolean bl, boolean bl2, CodeAttr codeAttr) {
        Class clazz = null;
        try {
            if (!string2.endsWith(";")) {
                clazz = this.findClass(string2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            if (!bl2) {
                codeAttr.addInsn(new Insn(25, 0));
            }
            if (bl) {
                codeAttr.addInsn(new Insn(this.loadCode(clazz), bl2 ? 0 : 1));
                codeAttr.addInsn(new Insn(bl2 ? 179 : 181, (CP)new FieldCP(this.className(), string, string2)));
                if (!bl2) {
                    codeAttr.addInsn(new Insn(25, 0));
                }
                codeAttr.addInsn(new Insn(bl2 ? 184 : 182, (CP)new MethodCP(this.className(), string, "()" + string2)));
            } else {
                codeAttr.addInsn(new Insn(bl2 ? 178 : 180, (CP)new FieldCP(this.className(), string, string2)));
            }
            if (clazz != null) {
                this.addReturn(clazz, codeAttr, false);
            } else {
                codeAttr.addInsn(new Insn(176));
            }
        }
        catch (jasError jasError2) {
            jasError2.printStackTrace();
            return null;
        }
        return codeAttr;
    }

    public CodeAttr addConstructor(Constructor constructor) {
        CodeAttr codeAttr = new CodeAttr();
        String string = "(";
        Class<?>[] classArray = constructor.getParameterTypes();
        int n = classArray == null ? 2 : classArray.length + 2;
        codeAttr.setStackSize((short)n);
        codeAttr.setVarSize((short)n);
        try {
            codeAttr.addInsn(new Insn(25, 0));
        }
        catch (jasError jasError2) {
            jasError2.printStackTrace();
            return null;
        }
        if (this.Debug()) {
            System.out.println("Adding constructor " + constructor);
        }
        if (classArray != null) {
            int n2 = 1;
            int n3 = -1;
            int n4 = 0;
            while (n4 < classArray.length) {
                n3 = classArray[n4].isPrimitive() ? (int)this.primitiveLoadOp(classArray[n4]) : 25;
                try {
                    codeAttr.addInsn(new Insn((int)((short)n3), n2));
                }
                catch (jasError jasError3) {
                    jasError3.printStackTrace();
                    return null;
                }
                if (n3 == 24 || n3 == 22) {
                    ++n2;
                }
                string = String.valueOf(string) + this.className(classArray[n4], true);
                ++n4;
                ++n2;
            }
            string = String.valueOf(string) + ")V";
            if (this.Debug()) {
                System.out.println("Inherited constructor signature " + this.superClassName() + " " + string);
            }
        } else {
            string = "()V";
        }
        try {
            codeAttr.addInsn(new Insn(183, (CP)new MethodCP(this.superClassName(), "<init>", string)));
            codeAttr.addInsn(new Insn(177));
        }
        catch (jasError jasError4) {
            jasError4.printStackTrace();
            return null;
        }
        this.classDef().addMethod((short)1, "<init>", string, codeAttr, null);
        return codeAttr;
    }

    public Var addField(Var var) {
        if (var == null) {
            System.err.println("null field definition passed to addField()");
            return null;
        }
        this.classDef().addField(var);
        return var;
    }

    public Var addField(String string, Class clazz) {
        return this.addField(string, this.className(clazz, true));
    }

    public Var addField(String string, Class clazz, short s) {
        return this.addField(string, this.className(clazz, true), s);
    }

    public Var addField(String string, String string2) {
        return this.addField(string, string2, (short)4);
    }

    public Var addField(String string, String string2, short s) {
        return this.addField(string, string2, s, (s & 1) == 0);
    }

    public Var addField(String string, String string2, short s, boolean bl) {
        Var var = new Var(s, (CP)new AsciiCP(string), (CP)new AsciiCP(string2.replace('.', '/')), null);
        if (this.addField(var) != null && bl) {
            this.addFieldAccessors(string, string2, s);
        }
        return var;
    }

    public boolean addFieldAccessors(String string, String string2) {
        return this.addFieldAccessors(string, string2, (short)1);
    }

    public boolean addFieldAccessors(String string, String string2, short s) {
        return this.addFieldAccessors(string, string2, s, BOTH);
    }

    public boolean addFieldAccessors(String string, String string2, short s, int n) {
        CodeAttr codeAttr;
        int n2 = 1;
        boolean bl = false;
        if ((8 & s) != 0) {
            n2 |= 8;
            bl = true;
        }
        if ((n & GET) != 0) {
            codeAttr = this.accessorBody(string, string2, false, bl);
            this.classDef().addMethod((short)n2, string, "()" + string2, codeAttr, null);
        }
        if ((n & SET) != 0) {
            codeAttr = this.accessorBody(string, string2, true, bl);
            this.classDef().addMethod((short)n2, string, "(" + string2 + ")" + string2, codeAttr, null);
        }
        return true;
    }

    public int addInheritedConstructors() {
        Class<?> clazz;
        String string = this.superClassName().replace('/', '.');
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Can't load " + string);
            classNotFoundException.printStackTrace();
            return -1;
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = 0;
        while (n < constructorArray.length) {
            this.addConstructor(constructorArray[n]);
            ++n;
        }
        return constructorArray.length;
    }

    public boolean addReturn(Class clazz, CodeAttr codeAttr) throws jasError {
        return this.addReturn(clazz, codeAttr, true);
    }

    public boolean addReturn(Class clazz, CodeAttr codeAttr, boolean bl) throws jasError {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Void.TYPE)) {
                codeAttr.addInsn(new Insn(87));
                codeAttr.addInsn(new Insn(177));
            } else {
                this.returnPrimitive(clazz, codeAttr, bl);
            }
        } else {
            codeAttr.addInsn(new Insn(192, (CP)new ClassCP(this.className(clazz))));
            codeAttr.addInsn(new Insn(176));
        }
        return true;
    }

    public ClassEnv classDef() {
        if (this.classDef == null) {
            this.initClassDef();
        }
        return this.classDef;
    }

    public ClassEnv classDef(ClassEnv classEnv) {
        this.classDef = classEnv;
        return this.classDef();
    }

    public String className() {
        String string = "";
        string = this.packageName();
        if (string == null) {
            string = "";
        }
        string = String.valueOf(string) + this.className;
        return string;
    }

    public String className(Class clazz) {
        return this.className(clazz, false);
    }

    public String className(Class clazz, boolean bl) {
        String string;
        if (clazz.isPrimitive()) {
            string = this.mapPrimitive(clazz);
        } else if (clazz.isArray()) {
            String string2 = "";
            Class<?> clazz2 = clazz;
            do {
                string2 = String.valueOf(string2) + "[";
            } while ((clazz2 = clazz2.getComponentType()) != null && clazz2.isArray());
            string = String.valueOf(string2) + this.className(clazz2, true);
        } else {
            string = clazz.getName().replace('.', '/');
            if (bl) {
                string = "L" + string + ";";
            }
        }
        return string;
    }

    public String className(String string) {
        this.className = string.replace('.', '/');
        return this.className;
    }

    public File file() {
        return this.output;
    }

    public File file(File file) {
        this.output = file;
        return this.file();
    }

    public Class findClass(String string) throws ClassNotFoundException {
        return ((BasicEvaluator)Globals.evaluator()).findClass(string, false);
    }

    public Class findClass(Name name) throws ClassNotFoundException {
        return Globals.evaluator().findClass(name);
    }

    public ClassEnv initClassDef() {
        if (this.classDef != null) {
            return this.classDef();
        }
        this.classDef(new ClassEnv());
        if (this.Debug()) {
            System.out.println("Class name " + this.className());
        }
        this.classDef().setClass((CP)new ClassCP(this.className()));
        if (this.Debug()) {
            System.out.println("Super class " + this.superClassName());
        }
        this.classDef().setSuperClass((CP)new ClassCP(this.superClassName()));
        this.classDef().setClassAccess((short)1);
        this.classDef().setSource("Automatically generated by the Omega environment.");
        return this.classDef();
    }

    public int loadCode(Class clazz) {
        int n = 25;
        if (clazz == null) {
            return n;
        }
        if (clazz.isPrimitive()) {
            n = 21;
            if (clazz == Double.TYPE) {
                n = 24;
            } else if (clazz == Double.TYPE) {
                n = 24;
            } else if (clazz == Float.TYPE) {
                n = 23;
            } else if (clazz == Boolean.TYPE) {
                n = 21;
            } else if (clazz == Long.TYPE) {
                n = 22;
            }
        }
        return n;
    }

    public String mapPrimitive(Class clazz) {
        String string = clazz.equals(Byte.TYPE) ? "B" : (clazz.equals(Character.TYPE) ? "C" : (clazz.equals(Double.TYPE) ? "D" : (clazz.equals(Float.TYPE) ? "F" : (clazz.equals(Integer.TYPE) ? "I" : (clazz.equals(Long.TYPE) ? "J" : (clazz.equals(Short.TYPE) ? "S" : (clazz.equals(Boolean.TYPE) ? "Z" : (clazz.equals(Void.TYPE) ? "V" : null))))))));
        return string;
    }

    public String packageName() {
        return this.packageName;
    }

    public String packageName(String string) {
        if (string != null) {
            this.packageName = string.replace('.', '/');
        }
        return this.packageName();
    }

    public short primitiveLoadOp(Class clazz) {
        int n = 21;
        if (clazz.equals(Double.TYPE)) {
            n = 24;
        } else if (clazz.equals(Float.TYPE)) {
            n = 23;
        } else if (clazz.equals(Long.TYPE)) {
            n = 22;
        }
        return (short)n;
    }

    public String primitiveToClass(Class clazz) {
        String string = null;
        if (clazz.equals(Integer.TYPE)) {
            string = "Integer";
        } else if (clazz.equals(Double.TYPE)) {
            string = "Double";
        } else if (clazz.equals(Long.TYPE)) {
            string = "Long";
        } else if (clazz.equals(Float.TYPE)) {
            string = "Float";
        } else if (clazz.equals(Boolean.TYPE)) {
            string = "Boolean";
        } else if (clazz.equals(Short.TYPE)) {
            string = "Short";
        } else if (clazz.equals(Character.TYPE)) {
            string = "Character";
        } else if (clazz.equals(Byte.TYPE)) {
            string = "Byte";
        }
        if (string != null) {
            string = "java/lang/" + string;
        }
        return string;
    }

    public boolean returnPrimitive(Class clazz, CodeAttr codeAttr) throws jasError {
        return this.returnPrimitive(clazz, codeAttr, true);
    }

    public boolean returnPrimitive(Class clazz, CodeAttr codeAttr, boolean bl) throws jasError {
        MethodCP methodCP = null;
        int n = 172;
        if (bl) {
            codeAttr.addInsn(new Insn(192, (CP)new ClassCP(this.primitiveToClass(clazz))));
            methodCP = new MethodCP(this.primitiveToClass(clazz), String.valueOf(clazz.toString()) + "Value", "()" + this.className(clazz));
            codeAttr.addInsn(new Insn(182, (CP)methodCP));
        }
        if (this.Debug()) {
            System.out.print("Extracting primitive return value \n\t");
            System.out.println(String.valueOf(this.primitiveToClass(clazz)) + " " + clazz.toString() + "Value" + "()" + this.className(clazz));
        }
        if (clazz.equals(Integer.TYPE)) {
            n = 172;
        } else if (clazz.equals(Double.TYPE)) {
            n = 175;
        } else if (clazz.equals(Long.TYPE)) {
            n = 173;
        } else if (clazz.equals(Float.TYPE)) {
            n = 174;
        }
        codeAttr.addInsn(new Insn((int)((short)n)));
        return true;
    }

    public String superClassName() {
        return this.superClassName;
    }

    public String superClassName(String string) {
        this.superClassName = string.replace('.', '/');
        return this.superClassName();
    }

    public boolean warning(String string) {
        System.err.println(string);
        return true;
    }

    public boolean write() {
        File file = this.file();
        if (file == null) {
            file = new File(String.valueOf(this.className()) + ".class");
        }
        return this.write(file);
    }

    public boolean write(DataOutputStream dataOutputStream) {
        try {
            this.classDef().write(dataOutputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean write(File file) {
        DataOutputStream dataOutputStream = null;
        try {
            try {
                dataOutputStream = new DataOutputStream(new FileOutputStream(file));
                this.classDef().write(dataOutputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                boolean bl = false;
                Object var5_5 = null;
                if (dataOutputStream == null) return bl;
                try {
                    dataOutputStream.close();
                    return bl;
                }
                catch (Exception exception2) {}
                return bl;
            }
            Object var5_6 = null;
            if (dataOutputStream == null) return true;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (dataOutputStream == null) throw throwable;
            try {
                dataOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            dataOutputStream.close();
            return true;
        }
        catch (Exception exception) {}
        return true;
    }

    public boolean write(OutputStream outputStream) {
        return this.write(new DataOutputStream(outputStream));
    }

    public boolean write(String string) {
        return this.write(new File(string));
    }
}

