/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRPackageManager;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.util.Platform;

public class JGRPrefs {
    public static final int prefsVersion = 258;
    public static final int DEBUG = 0;
    public static boolean isMac = false;
    public static boolean isWindows = false;
    public static String FontName = "Monospaced";
    public static int FontStyle = 0;
    public static int FontSize = 12;
    public static final int MINFONTSIZE = 18;
    public static Font DefaultFont;
    public static Color HighLightColor;
    public static Color CMDColor;
    public static Color RESULTColor;
    public static Color ERRORColor;
    public static Color BRACKETHighLight;
    public static MutableAttributeSet DEFAULTFONT;
    public static MutableAttributeSet SIZE;
    public static MutableAttributeSet CMD;
    public static MutableAttributeSet RESULT;
    public static MutableAttributeSet NORMAL;
    public static MutableAttributeSet NUMBER;
    public static Color NUMBERColor;
    public static MutableAttributeSet KEYWORD;
    public static Color KEYWORDColor;
    public static boolean KEYWORD_BOLD;
    public static MutableAttributeSet OBJECT;
    public static Color OBJECTColor;
    public static boolean OBJECT_IT;
    public static boolean AUTOTAB;
    public static MutableAttributeSet COMMENT;
    public static Color COMMENTColor;
    public static boolean COMMENT_IT;
    public static MutableAttributeSet QUOTE;
    public static Color QUOTEColor;
    public static boolean LINE_HIGHLIGHT;
    public static Color HIGHLIGHTColor;
    public static boolean LINE_NUMBERS;
    public static int maxHelpTabs;
    public static boolean useHelpAgent;
    public static boolean useHelpAgentEditor;
    public static boolean useHelpAgentConsole;
    public static boolean useEmacsKeyBindings;
    public static boolean showHiddenFiles;
    public static String previousPackages;
    public static String workingDirectory;
    public static String defaultPackages;
    public static boolean askForSavingWorkspace;
    public static int tabWidth;

    public static void apply() {
        JGRPrefs.refresh();
        FontTracker.current.applyFont();
    }

    public static void initialize() {
        FontSize = isWindows ? 10 : 12;
        JGRPrefs.readPrefs();
        DefaultFont = new Font(FontName, FontStyle, FontSize);
        StyleConstants.setFontSize(SIZE, FontSize);
        StyleConstants.setFontSize(DEFAULTFONT, FontSize);
        StyleConstants.setFontFamily(DEFAULTFONT, FontName);
        StyleConstants.setForeground(CMD, CMDColor);
        StyleConstants.setForeground(RESULT, RESULTColor);
        StyleConstants.setForeground(NORMAL, Color.black);
        StyleConstants.setFontSize(NORMAL, FontSize);
        StyleConstants.setForeground(NUMBER, NUMBERColor);
        StyleConstants.setForeground(COMMENT, COMMENTColor);
        StyleConstants.setItalic(COMMENT, COMMENT_IT);
        StyleConstants.setForeground(KEYWORD, KEYWORDColor);
        StyleConstants.setBold(KEYWORD, KEYWORD_BOLD);
        StyleConstants.setForeground(OBJECT, OBJECTColor);
        StyleConstants.setItalic(OBJECT, OBJECT_IT);
        StyleConstants.setForeground(QUOTE, QUOTEColor);
    }

    public static void refresh() {
        DefaultFont = new Font(FontName, FontStyle, FontSize);
        StyleConstants.setFontSize(SIZE, FontSize);
        StyleConstants.setFontSize(DEFAULTFONT, FontSize);
        StyleConstants.setFontFamily(DEFAULTFONT, FontName);
        StyleConstants.setForeground(CMD, CMDColor);
        StyleConstants.setForeground(RESULT, RESULTColor);
        StyleConstants.setForeground(NORMAL, Color.black);
        StyleConstants.setFontSize(NORMAL, FontSize);
        StyleConstants.setForeground(NUMBER, NUMBERColor);
        StyleConstants.setForeground(COMMENT, COMMENTColor);
        StyleConstants.setItalic(COMMENT, COMMENT_IT);
        StyleConstants.setForeground(KEYWORD, KEYWORDColor);
        StyleConstants.setBold(KEYWORD, KEYWORD_BOLD);
        StyleConstants.setForeground(OBJECT, OBJECTColor);
        StyleConstants.setItalic(OBJECT, OBJECT_IT);
        StyleConstants.setForeground(QUOTE, QUOTEColor);
        if (JGR.getREngine() != null && JGR.STARTED) {
            try {
                JGR.eval("options(width=" + JGR.MAINRCONSOLE.getFontWidth() + ")");
            }
            catch (REngineException rEngineException) {
                new ErrorMsg(rEngineException);
            }
            catch (REXPMismatchException rEXPMismatchException) {
                new ErrorMsg(rEXPMismatchException);
            }
        }
    }

    public static void readPrefs() {
        Preferences preferences;
        BufferedInputStream bufferedInputStream;
        block17: {
            Preferences preferences2;
            block16: {
                bufferedInputStream = null;
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(System.getProperty("user.home") + File.separator + ".JGRprefsrc"));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                try {
                    if (bufferedInputStream == null) break block16;
                    preferences2 = Preferences.userNodeForPackage(JGR.class);
                    try {
                        preferences2.clear();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    preferences2 = null;
                    Preferences.importPreferences(bufferedInputStream);
                }
                catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (bufferedInputStream == null) {
                return;
            }
            preferences2 = Preferences.userNodeForPackage(JGR.class);
            FontName = preferences2.get("FontName", FontName);
            defaultPackages = preferences2.get("DefaultPackages", null);
            FontSize = preferences2.getInt("FontSize", FontSize);
            int n = Toolkit.getDefaultToolkit().getScreenResolution();
            double d = (double)preferences2.getInt("FontSize", FontSize) * ((double)n / 72.0);
            FontSize = (int)Math.round(d);
            maxHelpTabs = preferences2.getInt("MaxHelpTabs", maxHelpTabs);
            useHelpAgent = preferences2.getBoolean("UseHelpAgent", true);
            useHelpAgentConsole = preferences2.getBoolean("UseHelpAgentConsole", useHelpAgentConsole);
            useHelpAgentEditor = preferences2.getBoolean("UseHelpAgentEditor", useHelpAgentEditor);
            useEmacsKeyBindings = preferences2.getBoolean("UseEmacsKeyBindings", Platform.isMac);
            previousPackages = preferences2.get("PreviousPackages", null);
            showHiddenFiles = preferences2.getBoolean("ShowHiddenFiles", false);
            workingDirectory = preferences2.get("WorkingDirectory", System.getProperty("user.home"));
            tabWidth = preferences2.getInt("tabWidth", 4);
            askForSavingWorkspace = preferences2.getBoolean("AskForSavingWorkspace", true);
            bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(System.getProperty("user.home") + File.separator + ".JGREditorprefsrc"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            try {
                if (bufferedInputStream == null) break block17;
                preferences = Preferences.userNodeForPackage(Editor.class);
                try {
                    preferences.clear();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                preferences = null;
                Preferences.importPreferences(bufferedInputStream);
            }
            catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
                new ErrorMsg(invalidPreferencesFormatException);
            }
            catch (IOException iOException) {
                new ErrorMsg(iOException);
            }
        }
        if (bufferedInputStream == null) {
            return;
        }
        preferences = Preferences.userNodeForPackage(Editor.class);
        CMDColor = Color.decode(preferences.get("CMDColor", "#ff0000"));
        RESULTColor = Color.decode(preferences.get("RESULTColor", "#0000ff"));
        ERRORColor = Color.decode(preferences.get("ERRORColor", "#ff0000"));
        BRACKETHighLight = Color.decode(preferences.get("BRACKETHighLight", "#ffffff"));
        NUMBERColor = Color.decode(preferences.get("NUMBERColor", "#ff0000"));
        KEYWORDColor = Color.decode(preferences.get("KEYWORDColor", "#00008c"));
        KEYWORD_BOLD = preferences.getBoolean("KEYWORD_BOLD", true);
        OBJECTColor = Color.decode(preferences.get("OBJECTColor", "#32008c"));
        OBJECT_IT = preferences.getBoolean("OBJECT_IT", true);
        AUTOTAB = preferences.getBoolean("AUTOTAB", true);
        COMMENTColor = Color.decode(preferences.get("COMMENTColor", "#000000"));
        COMMENT_IT = preferences.getBoolean("COMMENT_IT", true);
        QUOTEColor = Color.decode(preferences.get("QUOTEColor", "#0000ff"));
        LINE_HIGHLIGHT = preferences.getBoolean("LINE_HIGHLIGHT", true);
        HIGHLIGHTColor = Color.decode(preferences.get("HIGHLIGHTColor", "#e0e0e0"));
        LINE_NUMBERS = preferences.getBoolean("LINE_NUMBERS", true);
    }

    public static void writePrefs(boolean bl) {
        int n;
        Object object;
        Preferences preferences = Preferences.userNodeForPackage(JGR.class);
        try {
            preferences.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        preferences.putBoolean("AskForSavingWorkspace", askForSavingWorkspace);
        preferences.putInt("PrefsVersion", 258);
        preferences.put("FontName", FontName);
        int n2 = Toolkit.getDefaultToolkit().getScreenResolution();
        double d = (double)FontSize * (72.0 / (double)n2);
        preferences.putInt("FontSize", (int)Math.round(d));
        preferences.putInt("MaxHelpTabs", maxHelpTabs);
        preferences.putBoolean("UseHelpAgent", useHelpAgent);
        preferences.putBoolean("UseHelpAgentConsole", useHelpAgentConsole);
        preferences.putBoolean("UseHelpAgentEditor", useHelpAgentEditor);
        preferences.putBoolean("UseEmacsKeyBindings", useEmacsKeyBindings);
        preferences.putBoolean("ShowHiddenFiles", showHiddenFiles);
        preferences.put("PreviousPackages", RController.getCurrentPackages() + (JGRPackageManager.remindPackages == null ? "" : "," + JGRPackageManager.remindPackages));
        preferences.put("WorkingDirectory", workingDirectory);
        preferences.putInt("tabWidth", tabWidth);
        if (JGRPackageManager.defaultPackages != null && JGRPackageManager.defaultPackages.length > 0) {
            object = JGRPackageManager.defaultPackages[JGRPackageManager.defaultPackages.length - 1].toString();
            for (n = JGRPackageManager.defaultPackages.length - 2; n >= 0; --n) {
                String string = (String)JGRPackageManager.defaultPackages[n];
                if ("JGR".equals(string) || "rJava".equals(string) || "JavaGD".equals(string) || "iplots".equals(string)) continue;
                object = (String)object + ", " + string;
            }
            preferences.put("DefaultPackages", (String)object);
        }
        if (JGR.RLIBS != null && JGR.RLIBS.length > 1) {
            object = JGR.RLIBS[0].toString();
            for (n = 1; n < JGR.RLIBS.length - 1; ++n) {
                object = (String)object + (isWindows ? ";" : ":") + JGR.RLIBS[n];
            }
            preferences.put("InitialRLibraryPath", (String)object);
        }
        try {
            preferences.exportNode(new FileOutputStream(System.getProperty("user.home") + File.separator + ".JGRprefsrc"));
        }
        catch (IOException iOException) {
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        object = Preferences.userNodeForPackage(Editor.class);
        try {
            ((Preferences)object).clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Preferences)object).putInt("PrefsVersion", 258);
        ((Preferences)object).put("CMDColor", "#" + Integer.toHexString(CMDColor.getRGB()).substring(2));
        ((Preferences)object).put("RESULTColor", "#" + Integer.toHexString(RESULTColor.getRGB()).substring(2));
        ((Preferences)object).put("ERRORColor", "#" + Integer.toHexString(ERRORColor.getRGB()).substring(2));
        ((Preferences)object).put("BRACKETHighLight", "#" + Integer.toHexString(BRACKETHighLight.getRGB()).substring(2));
        ((Preferences)object).put("NUMBERColor", "#" + Integer.toHexString(NUMBERColor.getRGB()).substring(2));
        ((Preferences)object).put("KEYWORDColor", "#" + Integer.toHexString(KEYWORDColor.getRGB()).substring(2));
        ((Preferences)object).putBoolean("KEYWORD_BOLD", KEYWORD_BOLD);
        ((Preferences)object).put("OBJECTColor", "#" + Integer.toHexString(OBJECTColor.getRGB()).substring(2));
        ((Preferences)object).putBoolean("OBJECT_IT", OBJECT_IT);
        ((Preferences)object).putBoolean("AUTOTAB", AUTOTAB);
        ((Preferences)object).put("COMMENTColor", "#" + Integer.toHexString(COMMENTColor.getRGB()).substring(2));
        ((Preferences)object).putBoolean("COMMENT_IT", COMMENT_IT);
        ((Preferences)object).put("QUOTEColor", "#" + Integer.toHexString(QUOTEColor.getRGB()).substring(2));
        ((Preferences)object).putBoolean("LINE_HIGHLIGHT", LINE_HIGHLIGHT);
        ((Preferences)object).put("HIGHLIGHTColor", "#" + Integer.toHexString(HIGHLIGHTColor.getRGB()).substring(2));
        ((Preferences)object).putBoolean("LINE_NUMBERS", LINE_NUMBERS);
        try {
            ((Preferences)object).exportNode(new FileOutputStream(System.getProperty("user.home") + File.separator + ".JGREditorprefsrc"));
        }
        catch (IOException iOException) {
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static void writeCurrentPackagesWhenExit() {
        JGRPrefs.readPrefs();
        JGRPrefs.writePrefs(false);
    }

    static {
        HighLightColor = Color.green;
        CMDColor = Color.red;
        RESULTColor = Color.black;
        ERRORColor = Color.red;
        BRACKETHighLight = new Color(200, 255, 255);
        DEFAULTFONT = new SimpleAttributeSet();
        SIZE = new SimpleAttributeSet();
        CMD = new SimpleAttributeSet();
        RESULT = new SimpleAttributeSet();
        NORMAL = new SimpleAttributeSet();
        NUMBER = new SimpleAttributeSet();
        NUMBERColor = Color.red;
        KEYWORD = new SimpleAttributeSet();
        KEYWORDColor = new Color(0, 0, 140);
        KEYWORD_BOLD = true;
        OBJECT = new SimpleAttributeSet();
        OBJECTColor = new Color(50, 0, 140);
        OBJECT_IT = true;
        AUTOTAB = true;
        COMMENT = new SimpleAttributeSet();
        COMMENTColor = new Color(0, 120, 0);
        COMMENT_IT = true;
        QUOTE = new SimpleAttributeSet();
        QUOTEColor = Color.blue;
        LINE_HIGHLIGHT = true;
        HIGHLIGHTColor = new Color(0xE0E0E0);
        LINE_NUMBERS = true;
        maxHelpTabs = 10;
        useHelpAgent = true;
        useHelpAgentEditor = true;
        useHelpAgentConsole = true;
        useEmacsKeyBindings = false;
        showHiddenFiles = false;
        previousPackages = null;
        workingDirectory = System.getProperty("user.home");
        defaultPackages = null;
        askForSavingWorkspace = true;
        tabWidth = 4;
    }
}

