% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finding-objects.R
\name{with_text}
\alias{with_text}
\alias{with_text.IssuesTB}
\title{Check for text in GitHub Issues}
\usage{
with_text(x, ...)

\method{with_text}{IssuesTB}(x, ..., in_title = TRUE, in_body = TRUE, in_comments = TRUE)
}
\arguments{
\item{x}{An object of class \code{IssuesTB}.}

\item{...}{Additional arguments passed to \code{\link[=grepl]{grepl()}}, such as \code{pattern}
and \code{ignore.case}.}

\item{in_title}{Boolean. Does the function search for text in the title?
(Default \code{TRUE})}

\item{in_body}{Boolean. Does the function search for text in the body?
(Default \code{TRUE})}

\item{in_comments}{Boolean. Does the function search for text in the
comments? (Default \code{TRUE})}
}
\value{
An object \code{IssuesTB} with issues that satisfy the condition.
}
\description{
Generic function to search for a given text pattern in the title, body, or
comments of a GitHub Issue object or a collection of Issues.
}
\examples{
all_issues <- get_issues(
    source = "local",
    dataset_dir = system.file("data_issues", package = "IssueTrackeR"),
    dataset_name = "open_issues.yaml"
)
with_text(all_issues, pattern = "Excel")

}
