% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBackbone_function.R
\name{get.backbone}
\alias{get.backbone}
\title{get.backbone}
\usage{
get.backbone(G, alpha, directed = TRUE)
}
\arguments{
\item{G}{igraph network}

\item{alpha}{Signifcance level}

\item{directed}{Default is TRUE}
}
\value{
Backbone of the network
}
\description{
This function extract the backbone of a network
}
\examples{
require(igraph)
##Directed Graph
gs<-erdos.renyi.game(50,0.2,directed = TRUE)
E(gs)$weight<-runif(ecount(gs), 0, 1)

##Extract backbone at 0.05 significance level
backbone<-get.backbone(gs,0.1)

}
\references{
Serrano, M. Á., Boguñá, M. and Vespignani, A. (2009) Extracting the multiscale backbone of complex weighted networks, Proceedings of the National Academy of Sciences, 106(16), pp. 6483–6488.
}
