\name{check.overlap}
\alias{check.overlap}
\title{
Check if muscle fibers are redundant}
\description{
Determines whether muscle fibers are likely to be repeats. The function compares pairs of fibers and determines 1) whether they are within min.vox of each other, and 2) if the average distance between them stays less than min.vox. If so the longer fiber is kept and the redundant fiber is dropped.}
\usage{
check.overlap(fiber.list, min.vox, df = 2)
}
\arguments{
  \item{fiber.list}{
A list containing elements with $fiber.points. Generated by \code{\link{good.fibes}}, \code{\link{fibers.smoothed}}, \code{\link{quality.check}}, or \code{\link{fuse.fibers}}.
}
  \item{min.vox}{
The distance between fibers in voxels (pixels) for fibers to be considered redundant}
  \item{df}{
The degree of curvature for spline interpolation via splines::ns
}
}
\value{

\item{drop.fibers}{the index for the redundant fibers to be removed}

\item{overlapping.fibers}{a matrix with the compared fibers, the index of which were kept and which were removed in each comparison}

\item{fibers.removed}{a list with fiber.points with the redundant fibers excluded}
}
\references{
Arbour, J. In Prep. GoodFibes: an R package for the detection of muscle fibers from diceCT scans.}
\author{
J. Arbour}
\seealso{
\code{\link{fuse.fibers}},\code{\link{quality.check}},\code{\link{good.fibes}}
}
