% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal.plots.R
\name{marginal.plots}
\alias{marginal.plots}
\title{marginal.plots Plots the marginal response of a model to an environmental variable with all other variables held at their mean in env}
\usage{
marginal.plots(model, env, layer, standardize = TRUE, verbose = FALSE)
}
\arguments{
\item{model}{An enmtools model object}

\item{env}{A SpatRaster object containing environmental data}

\item{layer}{The name of the layer to plot}

\item{standardize}{Whether to set the maximum of the response function to 1, or to instead use the raw values.}

\item{verbose}{Controls printing of messages}
}
\value{
results A plot of the marginal response of the model to the environmental variable.
}
\description{
marginal.plots Plots the marginal response of a model to an environmental variable with all other variables held at their mean in env
}
\examples{
cyreni.glm <- enmtools.glm(iberolacerta.clade$species$cyreni,
f = pres ~ bio1 + bio12, euro.worldclim)
marginal.plots(cyreni.glm, euro.worldclim, "bio1")
}
\keyword{enm}
\keyword{plot}
\keyword{response}
\keyword{sdm}
