% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/model.em.R
\name{model.em}
\alias{model.em}
\title{Model all possible end-member scenarios.}
\usage{
model.em(X, q, l, plot = TRUE, col.q = TRUE, bw, ...)
}
\arguments{
\item{X}{Numeric matrix with m samples (rows) and n variables (columns).}

\item{q}{Numeric matrix, definitions of minimum and maximum number of
end-members (cf. \code{get.q()}), required.}

\item{l}{Numeric vector, weight transformation limit values, corresponding
to the matrix q, required.}

\item{plot}{Logical scalar, option to plot the results (cf. details for
explanations), default is \code{TRUE}.}

\item{col.q}{Logical scalar, option to colour end-member loadings by the
number of end-members which were used to create the model realisation,
default is \code{TRUE}.}

\item{bw}{Numeric scalar, optional manual setting of the kde bandwidth.
By default, bw is calculated as 1 percent of the number of grain-size
classes.}

\item{\dots}{Further arguments passed to the function.}
}
\value{
\code{List} object with all modelled end-members, each described by
input parameters, mode position, quality measures and value distributions.
}
\description{
This function takes a definition of weight transformation
limits and corresponding minimum and maximum numbers of end-members to
model all end-member scenarios in accordance with these parameters. Based
on the output the user can decide on robust end-members.
}
\details{
The plot output is an overlay of several data. The coloured lines in the
background are end-member loadings (number noted in the plot title),
resulting from all possible model scenarios. If \code{col.q == TRUE} they
are coloured according to the number of end-members with which the model
was generated. This colour scheme allows to depict end-members that emerge
for model realisations with specific number of end-members. The thick
black line is a kernel density estimate curve, generated from the mode
positions of all end-members. The kernel bandwidth is set to 1 percent of
the number of grain-size classes of the input data set, which gave useful
results for most of our test data sets. The cumulaitve dot-line-plot is a
further visualisation of end-member mode positions. The function is a
modified wrapper function for the function \code{test.robustness()}.
}
\examples{
## load example data set
data(X, envir = environment())

## define input parameters
l <- c(0, 0.05, 0.10)
q <- cbind(c(2, 2, 3), c(5, 6, 4))

## infer l-vector
em_pot <- model.em(X = X, q = q, l = l)
}
\author{
Michael Dietze, Elisabeth Dietze
}
\references{
Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S,
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for
deciphering modern detrital processes from lake sediments of Lake Donggi
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180.
}
\seealso{
\code{\link{EMMA}}, \code{\link{test.l.max}}
}
\keyword{EMMA}

