% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_metadata.R
\name{read_metadata}
\alias{read_metadata}
\title{Read metadata}
\usage{
read_metadata(packageId, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(xml_document) EML metadata document.

See the 
\href{https://CRAN.R-project.org/package=emld}{emld} library 
for more on working with EML as a list or JSON-LD. See the 
\href{https://CRAN.R-project.org/package=xml2}{xml2} library 
for working with EML as XML.
}
\description{
Read metadata
}
\examples{
\dontrun{

# Read metadata
eml <- read_metadata("edi.100.1")
eml
#> {xml_document}
#> <eml packageId="edi.100.1" system="https://pasta.edirepository.org"   ...
#> [1] <access authSystem="https://pasta.edirepository.org/authenticatio ...
#> [2] <dataset>\n  <alternateIdentifier system="https://doi.org">doi:10 ...
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_data_package}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()}
}
\concept{Accessing}
